
require './fdisk-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the fdisk module
sub acl_security_form
{
local @dlist = &list_disks();
local ($d, %dcan);
map { $dcan{$_}++ } split(/\s+/, $_[0]->{'disks'});
print "<tr> <td valign=top><b>$text{'acl_disks'}</b></td> ",
      "<td><select name=disks size=4 multiple>\n";
foreach $d (@dlist) {
	printf "<option value='%s' %s>%s\n",
		$d->{'device'},
		$dcan{$d->{'device'}} || $dcan{"*"} ? "selected" : "",
		&text('select_device', uc($d->{'type'}), uc(substr($d->{'device'}, -1))).($d->{'model'} ? " ($d->{'model'})" : "");
	}
print "</select></td> </tr>\n";
}

# acl_security_save(&options)
# Parse the form for security options for the fdisk module
sub acl_security_save
{
local @dlist = &list_disks();
local @sel = split(/\0/, $in{'disks'});
if (scalar(@dlist) == scalar(@sel)) {
	$_[0]->{'disks'} = "*";
	}
else {
	$_[0]->{'disks'} = join(" ", @sel);
	}
}

