#!/usr/local/bin/perl
# list_leases.cgi
# List all active leases

require './dhcpd-lib.pl';
&header($text{'listl_header'}, "");
print "<hr><p>\n";

if (!-r $config{'lease_file'}) {
	print "<b>";
	print(&text('listl_lfnotexist',$config{'lease_file'}));
	print "</b><p>\n";
	}
elsif (!&tokenize_file($config{'lease_file'}, \@tok) || !@tok) {
	print "<b>";
	print(&text('listl_lfnotcont',$config{'lease_file'}));
	print "</b><p>\n";
	}
else {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'listl_ipaddr'}</b></td> <td><b>$text{'listl_ether'}</b></td>\n";
	print "<td><b>$text{'listl_host'}</b></td> <td><b>$text{'listl_start'}</b></td>\n";
	print "<td><b>$text{'listl_end'}</b></td> </tr>\n";
	$i = $j = 0;
	while($i < @tok) {
		$lease = &parse_struct(\@tok, \$i, $j++, $config{'lease_file'});
		next if (!$lease);
		print "<tr $cb>\n";
		print "<td><tt>",$lease->{'values'}->[0],"</tt></td>\n";
		local $mems = $lease->{'members'};
		local $hard = &find('hardware', $mems);
		print "<td><tt>",$hard->{'values'}->[1],"</tt></td>\n";
		local $client = &find('client-hostname', $mems);
		print "<td><tt>",$client ? $client->{'values'}->[0]
					 : "<br>","</tt></td>\n";
		local $starts = &find('starts', $mems);
		print "<td><tt>",$starts->{'values'}->[1]," ",
				 $starts->{'values'}->[2],"</tt></td>\n";
		local $ends = &find('ends', $mems);
		print "<td><tt>",$ends->{'values'}->[1]," ",
				 $ends->{'values'}->[2],"</tt></td>\n";
		print "</tr>\n";
		}
	print "</table><p>\n";
	}

print "<hr>\n";
&footer("", $text{'listl_return'});

