#!/usr/local/bin/perl
# edit_recs.cgi
# Display records of some type from some domain

require './bind8-lib.pl';
&ReadParse();
$conf = &get_config();
$zconf = $conf->[$in{'index'}]->{'members'};
$dom = $conf->[$in{'index'}]->{'value'};
%access = &get_module_acl();
&can_edit_zone(\%access, $dom) || &error($text{'recs_ecannot'});
&header(&text('recs_title', $text{"type_$in{'type'}"}), "");
print "<center><font size=+2>",&text('recs_header', &arpa_to_ip($dom)),
      "</font></center>\n";
print "<hr>\n";

$type = &find("type", $zconf)->{'value'};
$file = &find("file", $zconf)->{'value'};
&record_input($in{'index'}, $in{'type'}, $file, $dom)
	if (!$access{'ro'} && $type eq 'master');
@recs = &read_zone_file($file, $dom);
@recs = grep { $_->{'type'} eq $in{'type'} } @recs;
if (@recs) {
	@recs = &sort_records(@recs);
	foreach $v (keys %text) {
		if ($v =~ /^value_(\S+)(\d+)/) {
			$hmap{$1}->[$2-1] = $text{$v};
			}
		}
	if ($in{'type'} =~ /HINFO|WKS|RP/) {
		&recs_table(@recs);
		}
	else {
		$mid = int((@recs+1)/2);
		print "<table width=100%><tr><td width=50% valign=top>\n";
		&recs_table(@recs[0 .. $mid-1]);
		print "</td><td width=50% valign=top>\n";
		if ($mid < @recs) { &recs_table(@recs[$mid .. $#recs]); }
		print "</td></tr></table><p>\n";
		}
	print "<p>\n";
	}
print "<hr>\n";
&footer("edit_$type.cgi?index=$in{'index'}", $text{'recs_return'});

sub recs_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>",$in{'type'} eq "PTR" ? $text{'recs_addr'}
					      : $text{'recs_name'},
      "</b></td> <td><b>$text{'recs_ttl'}</b></td>\n";
@hmap = @{$hmap{$in{'type'}}};
foreach $h (@hmap) {
	print "<td><b>$h</b></td>\n";
	}
print "</tr>\n";
for($i=0; $i<@_; $i++) {
	$r = $_[$i];
	$name = $in{'type'} eq "PTR" ? &arpa_to_ip($r->{'name'})
				     : $r->{'name'};
	if (!$access{'ro'} && $type eq 'master') {
		print "<tr $cb> <td><a href=\"edit_record.cgi?index=",
		      "$in{'index'}&type=$in{'type'}&num=$r->{'num'}\">$name",
		      "</a></td>\n";
		}
	else {
		print "<tr $cb> <td>$name</td>\n";
		}
	print "<td>",$r->{'ttl'} ? $r->{'ttl'} : $text{'default'},"</td>\n";
	for($j=0; $j<@hmap; $j++) {
		print "<td>$r->{'values'}->[$j]</td>\n";
		}
	print "</tr>\n";
	}
print "</table>\n";
}

