#!/usr/local/bin/perl
# manual_save.cgi
# Save manually entered directives

require './apache-lib.pl';
&ReadParse();
if (defined($in{'virt'})) {
	if (defined($in{'idx'})) {
		# directory within virtual server
		($vconf, $v) = &get_virtual_config($in{'virt'});
		$d = $vconf->[$in{'idx'}];
		$file = $d->{'file'};
		$start = $d->{'line'}+1; $end = $d->{'eline'}-1;
		}
	else {
		# virtual server
		($conf, $v) = &get_virtual_config($in{'virt'});
		$file = $v->{'file'};
		$start = $v->{'line'}+1; $end = $v->{'eline'}-1;
		}
	}
else {
	if (defined($in{'idx'})) {
		# files within .htaccess file
		$hconf = &get_htaccess_config($in{'file'});
		$d = $hconf->[$in{'idx'}];
		$file = $in{'file'};
		$start = $d->{'line'}+1; $end = $d->{'eline'}-1;
		}
	else {
		# .htaccess file
		$file = $in{'file'};
		}
	}

$in{'directives'} =~ s/\r//g;
$in{'directives'} =~ s/\s+$//;
@dirs = split(/\n/, $in{'directives'});
$lref = &read_file_lines($file);
if (!defined($start)) {
	$start = 0;
	$end = @$lref - 1;
	}
splice(@$lref, $start, $end-$start+1, @dirs);
&flush_file_lines();

foreach $h ('virt', 'idx', 'file') {
	push(@args, "$h=$in{$h}") if (defined($in{$h}));
	}
&redirect("show.cgi?".join("&", @args));

