#!/usr/local/bin/perl
# change_access.cgi
# Update IP allow and deny parameters

require './webmin-lib.pl';
use Socket;
&ReadParse();
&error_setup($text{'access_err'});

if ($in{"access"}) {
	@hosts = split(/\s+/, $in{"ip"});
	if (!@hosts) { &error($text{'access_enone'}); }
	$raddr = $ENV{'REMOTE_ADDR'};
	foreach $h (@hosts) {
		if ($h =~ /^([0-9\.]+)\/([0-9\.]+)$/) {
			&check_ipaddress($1) ||
				&error(&text('access_enet', $1));
			&check_ipaddress($2) ||
				&error(&text('access_emask', $2));
			$i = $h;
			}
		elsif ($h =~ /^[0-9\.]+$/) {
			&check_ipaddress($h) ||
				&error(&text('access_eip', $h));
			$i = $h;
			}
		elsif (!($i = join('.', unpack("CCCC", inet_aton($h))))) {
			&error(&text('access_ehost', $h));
			}
		push(@ip, $i);
		}
	if ($in{"access"} == 1 && !&ip_match($raddr, @ip) ||
	    $in{"access"} == 2 && &ip_match($raddr, @ip)) {
		&error(&text('access_eself', $raddr));
		}
	}

&get_miniserv_config(\%miniserv);
delete($miniserv{"allow"});
delete($miniserv{"deny"});
if ($in{"access"} == 1) { $miniserv{"allow"} = join(' ', @hosts); }
elsif ($in{"access"} == 2) { $miniserv{"deny"} = join(' ', @hosts); }
&put_miniserv_config(\%miniserv);
&restart_miniserv();
&redirect("");

# ip_match(ip, [match]+)
# Checks an IP address against a list of IPs, networks and networks/masks
sub ip_match
{
local(@io, @mo, @ms, $i, $j);
@io = split(/\./, $_[0]);
for($i=1; $i<@_; $i++) {
	local $mismatch = 0;
	if ($_[$i] =~ /^(\S+)\/(\S+)$/) {
		# Compare with network/mask
		@mo = split(/\./, $1); @ms = split(/\./, $2);
		for($j=0; $j<4; $j++) {
			if ((int($io[$j]) & int($ms[$j])) != int($mo[$j])) {
				$mismatch = 1;
				}
			}
		}
	else {
		# Compare with IP or network
		@mo = split(/\./, $_[$i]);
		while(@mo && !$mo[$#mo]) { pop(@mo); }
		for($j=0; $j<@mo; $j++) {
			if ($mo[$j] != $io[$j]) {
				$mismatch = 1;
				}
			}
		}
	return 1 if (!$mismatch);
	}
return 0;
}

