#!/usr/local/bin/perl
# edit_user.cgi
# Display a form for editing a user, or creating a new user

require './user-lib.pl';
require 'timelocal.pl';
&ReadParse();
$n = $in{'num'};
%access = &get_module_acl();
if ($n eq "") {
	$access{'ucreate'} || &error($text{'uedit_ecreate'});
	&header($text{'uedit_title2'}, "", "create_user");
	}
else {
	@ulist = &list_users();
	%uinfo = %{$ulist[$n]};
	&can_edit_user(\%access, \%uinfo) || &error($text{'uedit_eedit'});
	&header($text{'uedit_title'}, "", "edit_user");
	}

# build list of used shells and uids
setpwent();
@shlist = ("/bin/sh", "/bin/csh", "/bin/false");
while(@tmp = getpwent()) {
	$used{$tmp[2]}++;
	push(@shlist, $tmp[8]) if ($tmp[8] ne "");
	}
endpwent();
open(SHELLS, "/etc/shells");
while(<SHELLS>) {
	s/\r|\n//g;
	push(@shlist, $_);
	}
close(SHELLS);

print "<hr><form action=save_user.cgi method=post>\n";
if ($n ne "") {
	print "<input type=hidden name=num value=\"$n\">\n";
	}
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'uedit_details'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td>",&hlink("<b>$text{'user'}</b>","user"),"</td>\n";
print "<td><input name=user size=10 value=\"$uinfo{'user'}\"></td>\n";

print "<td>",&hlink("<b>$text{'uid'}</b>","uid"),"</td>\n";
if ($n eq "") {
	# Find the first free UID above the base
	$newuid = int($config{'base_uid'} > $access{'lowuid'} ?
			$config{'base_uid'} : $access{'lowuid'});
	while($used{$newuid}) {
		$newuid++;
		}
	print "<td><input name=uid size=10 value=\"$newuid\"></td> </tr>\n";
	}
else {
	print "<td><input name=uid size=10 value=$uinfo{'uid'}></td> </tr>\n";
	}

print "<tr> <td>",&hlink("<b>$text{'real'}</b>","real"),"</td>\n";
print "<td><input name=real size=20 value=\"$uinfo{'real'}\"></td>\n";

print "<td>",&hlink("<b>$text{'home'}</b>","home"),"</td>\n";
if ($access{'autohome'}) {
	print "<td><tt>",($n eq "" ? $text{'uedit_auto'}
				   : $uinfo{'home'}),"</tt>";
	}
else {
	print "<td><input name=home size=25 value=\"$uinfo{'home'}\">\n",
	      &file_chooser_button("home", 1);
	}
print "</td> </tr>\n";

print "<tr> <td valign=top>",&hlink("<b>$text{'shell'}</b>","shell"),"</td>\n";
print "<td valign=top><select name=shell>\n";
if ($access{'shells'} ne "*") {
	@shlist = %uinfo ? ($uinfo{'shell'}) : ();
	push(@shlist, split(/\s+/, $access{'shells'}));
	$shells = 1;
	}
@shlist = &unique(@shlist);
foreach $s (@shlist) {
	printf "<option value='%s' %s>%s\n", $s,
		$s eq $uinfo{'shell'} ? "selected" : "",
		$s eq "" ? "&lt;None&gt;" : $s;
	}
print "<option value=*>Other..\n" if (!$shells);
print "</select></td>\n";

$pass = %uinfo ? $uinfo{'pass'} : $config{'lock_string'};
print "<td valign=top rowspan=4>",&hlink("<b>$text{'pass'}</b>","pass"),
      "</td> <td rowspan=4>\n";
printf"<input type=radio name=passmode value=0 %s> %s<br>\n",
	$pass eq "" ? "checked" : "",
	$config{'empty_mode'} ? $text{'none1'} : $text{'none2'};
printf"<input type=radio name=passmode value=1 %s> $text{'nologin'}<br>\n",
	$pass eq $config{'lock_string'} ? "checked" : "";
printf"<input type=radio name=passmode value=2 %s> $text{'encrypted'}\n",
	$pass && $pass ne $config{'lock_string'} ? "checked" : "";
printf "<input name=encpass size=13 value=\"%s\"><br>\n",
	$pass && $pass ne $config{'lock_string'} ? $pass : "";
print "<input type=radio name=passmode value=3> $text{'clear'}\n";
printf "<input %s name=pass size=15></td> </tr>\n",
	$config{'passwd_stars'} ? "type=password" : "";

if (!$shells) {
	print "<tr> <td valign=top>$text{'uedit_other'}</td>\n";
	print "<td valign=top><input size=25 name=othersh>\n";
	print &file_chooser_button("othersh", 0),"</td> </tr>\n";
	print "<tr> <td colspan=2><br></td> </tr>\n";
	}
print "</table></td></tr></table><p>\n";

if (&passfiles_type() == 1 && $access{'peopt'}) {
	# This is a BSD system.. a few extra password options are supported
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'uedit_passopts'}</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";
	print "<tr> <td>",&hlink("<b>$text{'change2'}</b>",
				 "change2"),"</td>\n";
	if ($uinfo{'change'}) {
		@tm = localtime($uinfo{'change'});
		$cday = $tm[3];
		$cmon = $tm[4]+1;
		$cyear = $tm[5]+1900;
		$chour = sprintf "%2.2d", $tm[2];
		$cmin = sprintf "%2.2d", $tm[1];
		}
	print "<td>";
	&date_input($cday, $cmon, $cyear, 'change');
	print " &nbsp; <input name=changeh size=3 value=\"$chour\">";
	print ":<input name=changemi size=3 value=\"$cmin\"></td>\n";

	print "<td>",&hlink("<b>$text{'expire2'}</b>","expire2"),"</td>\n";
	if ($uinfo{'expire'}) {
		@tm = localtime($uinfo{'expire'});
		$eday = $tm[3];
		$emon = $tm[4]+1;
		$eyear = $tm[5]+1900;
		$ehour = sprintf "%2.2d", $tm[2];
		$emin = sprintf "%2.2d", $tm[1];
		}
	print "<td>";
	&date_input($eday, $emon, $eyear, 'expire');
	print " &nbsp; <input name=expireh size=3 value=\"$ehour\">";
	print ":<input name=expiremi size=3 value=\"$emin\"></td> </tr>\n";

	print "<tr> <td>",&hlink("<b>$text{'class'}</b>","class"),"</td>\n";
	print "<td><input name=class size=10 value=\"$uinfo{'class'}\"></td>\n";
	print "</tr>\n";
	print "</table></td></tr></table><p>\n";
	}

if (&passfiles_type() == 2 && $access{'peopt'}) {
	# System has a shadow password file as well.. which means it supports
	# password expiry and so on
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'uedit_passopts'}</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";
	print "<tr> <td>",&hlink("<b>$text{'change'}</b>","change"),"</td>\n";
	if ($uinfo{'change'}) {
		@tm = localtime(timelocal(gmtime($uinfo{'change'} * 60*60*24)));
		printf "<td>%s/%s/%s</td>\n",
			$tm[3], $text{"month_".($tm[4]+1)}, $tm[5]+1900;
		}
	elsif ($n eq "") { print "<td>$text{'uedit_never'}</td>\n"; }
	else { print "<td>$text{'uedit_unknown'}</td>\n"; }

	print "<td>",&hlink("<b>$text{'expire'}</b>","expire"),"</td>\n";
	if ($uinfo{'expire'}) {
		@tm = localtime($uinfo{'expire'} * 60*60*24);
		$eday = $tm[3];
		$emon = $tm[4]+1;
		$eyear = $tm[5]+1900;
		}
	print "<td>";
	&date_input($eday, $emon, $eyear, 'expire');
	print "</td>\n";

	print "<tr> <td>",&hlink("<b>$text{'min'}</b>","min"),"</td>\n";
	print "<td><input size=5 name=min value=\"$uinfo{'min'}\"></td>\n";

	print "<td>",&hlink("<b>$text{'max'}</b>","max"),"</td>\n";
	print "<td><input size=5 name=max value=\"$uinfo{'max'}\"></td></tr>\n";

	print "<tr> <td>",&hlink("<b>$text{'warn'}</b>","warn"),"</td>\n";
	print "<td><input size=5 name=warn value=\"$uinfo{'warn'}\"></td>\n";

	print "<td>",&hlink("<b>$text{'inactive'}</b>","inactive"),"</td>\n";
	print "<td><input size=5 name=inactive ",
	      "value=\"$uinfo{'inactive'}\"></td></tr>\n";

	print "</table></td></tr></table><p>\n";
	}

# Output group memberships
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'uedit_gmem'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";
print "<tr> <td valign=top>",&hlink("<b>$text{'group'}</b>","group"),
      "</td> <td valign=top>\n";
if ($config{'new_user_group'} && $n eq "") {
	print "<i>$text{'uedit_newg'}</i></td>\n";
	}
elsif ($access{'ugroups'} eq "*") {
	printf "<input name=gid size=8 value=\"%s\">\n",
		$n eq "" ? $config{'default_group'} : getgrgid($uinfo{'gid'});
	print &group_chooser_button("gid", 0),"</td>\n";
	}
else {
	print "<select name=gid>\n";
	local $cg = %uinfo ? getgrgid($uinfo{'gid'}) : undef;
	@gl = &unique($cg ? ($cg) : (), split(/\s+/, $access{'ugroups'}));
	foreach $g (@gl) {
		printf "<option %s>%s\n",
			$cg eq $g ? "selected" : "", $g;
		}
	print "</select></td>\n";
	}

print "<td valign=top>",&hlink("<b>$text{'uedit_2nd'}</b>","2nd"),"</td>\n";
print "<td><select name=sgid multiple size=5>\n";
map { $gcan{$_}++ } split(/\s+/, $access{'ugroups'});
foreach $g (&list_groups()) {
	@mems = split(/,/ , $g->{'members'});
	local $ismem = &indexof($uinfo{'user'}, @mems) >= 0;
	next if (!$gcan{'*'} && !$gcan{$g->{'group'}} && !$ismem);
	printf "<option value=\"$g->{'gid'}\" %s>$g->{'group'} ($g->{'gid'})\n",
		$ismem ? "selected" : "";
	}
print "</select></td> </tr>\n";
print "</table></td></tr></table><p>\n";

if ($n ne "") {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'onsave'}</b></td> </tr>\n";
	print "<tr $cb> <td><table>\n";
	print "<tr> <td>",&hlink($text{'uedit_movehome'},
				 "movehome"),"</td>\n";
	print "<td><input type=radio name=movehome value=1 checked> $text{'yes'}</td>\n";
	print "<td><input type=radio name=movehome value=0> $text{'no'}</td> </tr>\n";

	print "<tr> <td>",&hlink($text{'uedit_chuid'},"chuid"),"</td>\n";
	print "<td><input type=radio name=chuid value=0> $text{'no'}</td>\n";
	print "<td><input type=radio name=chuid value=1 checked> ",
	      "$text{'home'}</td>\n";
	print "<td><input type=radio name=chuid value=2> ",
	      "$text{'uedit_allfiles'}</td></tr>\n";

	print "<tr> <td>",&hlink($text{'chgid'},"chgid"),"</td>\n";
	print "<td><input type=radio name=chgid value=0> $text{'no'}</td>\n";
	print "<td><input type=radio name=chgid value=1 checked> ".
	      "$text{'home'}</td>\n";
	print "<td><input type=radio name=chgid value=2> ",
	      "$text{'uedit_allfiles'}</td></tr>\n";
	print "</table></td> </tr></table><p>\n";
	}
else {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'uedit_oncreate'}</b></td> </tr>\n";
	print "<tr $cb> <td><table>\n";
	print "<tr> <td>",&hlink($text{'uedit_makehome'},"makehome"),"</td>\n";
	print "<td><input type=radio name=makehome value=1 checked> $text{'yes'}</td>\n";
	print "<td><input type=radio name=makehome value=0> $text{'no'}</td> </tr>\n";

	if ($config{'user_files'} =~ /\S/) {
		print "<tr> <td>",&hlink($text{'uedit_copy'},
					 "copy_files"),"</td>\n";
		print "<td><input type=radio name=copy_files ",
		      "value=1 checked> $text{'yes'}</td>\n";
		print "<td><input type=radio name=copy_files ",
		      "value=0> $text{'no'}</td> </tr>\n";
		}
	print "</table></td> </tr></table><p>\n";
	}
if ($n ne "") {
	print "<table width=100%>\n";
	print "<tr> <td><input type=submit value=\"$text{'save'}\"></td>\n";

	print "</form><form action=\"list_logins.cgi\">\n";
	print "<input type=hidden name=username value=\"$uinfo{'user'}\">\n";
	print "<td align=center>\n";
	print "<input type=submit value=\"$text{'uedit_logins'}\"></td>\n";

	&foreign_require("sendmail", "sendmail-lib.pl");
	local %sconfig = &foreign_config("sendmail");
	if (-r $sconfig{'sendmail_cf'} && -x $sconfig{'sendmail_path'} &&
	    &foreign_call("sendmail", "check_sendmail_version",
		&foreign_call("sendmail", "get_sendmailcf"))) {
		print "</form><form action=/sendmail/list_mail.cgi>\n";
		print "<input type=hidden name=user value='$uinfo{'user'}'>\n";
		print "<td align=center>\n";
		print "<input type=submit value='$text{'uedit_mail'}'></td>\n";
		}

	print "</form><form action=\"delete_user.cgi\">\n";
	print "<input type=hidden name=num value=\"$n\">\n";
	print "<input type=hidden name=user value=\"$uinfo{'user'}\">\n";
	print "<td align=right><input type=submit value=\"$text{'delete'}\"></td> </tr>\n";
	print "</form></table><p>\n";
	}
else {
	print "<input type=submit value=\"$text{'create'}\"></form><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

# date_input(day, month, year, prefix)
sub date_input
{
print "<input name=$_[3]d size=3 value='$_[0]'>";
print "/<select name=$_[3]m>\n";
printf "<option %s>\n", $_[1] ? '' : 'selected';
local $m;
foreach $m (1..12) {
	printf "<option value=%d %s>%s\n",
		$m, $_[1] eq $m ? 'selected' : '', $text{"month_$m"};
	}
print "</select>";
print "/<input name=$_[3]y size=5 value='$_[2]'>";
}

