#!/usr/local/bin/perl
# list_domains.cgi
# Display a list of all domain mappings

require './sendmail-lib.pl';
require './domain-lib.pl';
$access{'domains'} || &error($text{'domains_ecannot'});
&header($text{'domains_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
$dfile = &domains_file($conf);
($ddbm, $ddbmtype) = &domains_dbm($conf);
if (!$ddbm) {
	# No Kdomain directive in sendmail.cf
	print "<p><b>",$text{'domains_econfig'},"</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
if (!-r $dfile) {
	# Text file not found
	print "<p><b>",&text('domains_efile', "<tt>$dfile</tt>",
	      "<tt>$ddbm</tt>", "/config.cgi?$module_name"),"</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
@doms = &list_domains($dfile);

&domain_form();
if (@doms) {
	# sort if needed
	if ($config{'sort_mode'} == 1) {
		@doms = sort { $a->{'from'} cmp $b->{'from'} } @doms;
		}

	# render table of domains
	$mid = int((@doms+1)/2);
	print "<table width=100%> <tr><td width=50% valign=top>\n";
	&doms_table(@doms[0..$mid-1]);
	print "</td><td width=50% valign=top>\n";
	if ($mid < @doms) { &doms_table(@doms[$mid..$#doms]); }
	print "</td></tr> </table><br>\n";
	}
print $text{'domains_desc'},"<p>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub doms_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'domains_from'}</b></td> ",
      "<td><b>$text{'domains_to'}</b></td> </tr>\n";
foreach $m (@_) {
	print "<tr $cb> <td><a href=\"edit_domain.cgi?num=$m->{'num'}\">",
	      "$m->{'from'}</a></td>\n";
	print "<td>$m->{'to'}</td> </tr>\n";
	}
print "</table>\n";
}

