#!/usr/local/bin/perl
# swat.cgi
# Pass everything to samba's SWAT tool

require './samba-lib.pl';
&ReadParse();

# Check is hosts allow is in force
&get_share("global");
if ($share{'hosts allow'}) {
	&header("Error", "");
	print "<hr>\n";
	print "<p>You cannot run SWAT through Webmin, as your Samba\n";
	print "configuration has the <tt>hosts allow</tt> option set.<p>\n";
	&foreign_require("inetd", "inetd-lib.pl");
	local @inets = &foreign_call("inetd", "list_inets");
	foreach $i (@inets) {
		if ($i->[3] eq 'swat' && $i->[1]) {
			# swat is configured in inetd!
			local $p = getservbyname('swat', 'tcp');
			$url = "http://$ENV{'SERVER_NAME'}:$p/";
			print "However, you may be able to connect to SWAT\n";
			print "directly at <a href='$url'>$url</a><p>\n";
			}
		}
	print "<hr>\n";
	&footer("", "share list");
	exit;
	}

# Check if we have the password
&read_file("$module_config_directory/swat", \%swat) || &ask_password();

# Execute SWAT process
pipe(OUTr, OUTw);
pipe(INr, INw);
local $pid = fork();
if (!$pid) {
	open(STDIN, "<&INr");
	open(STDOUT, ">&OUTw");
	open(STDERR, ">&OUTw");
	close(OUTr); close(INw);
	undef %ENV;
	exec($config{'swat_path'});
	print "Exec failed : $!\n";
	exit 1;
	}
close(OUTw); close(INr);

# Feed HTTP request and read output
$auth = &encode_base64("$swat{'user'}:$swat{'pass'}");
$auth =~ s/\n//g;
select(INw); $| = 1; select(STDOUT);
if ($ENV{'REQUEST_METHOD'} eq 'GET') {
	print INw "GET $ENV{'PATH_INFO'}?$in HTTP/1.0\n";
	print INw "Authorization: basic $auth\n";
	print INw "\n";
	}
else {
	print INw "POST $ENV{'PATH_INFO'} HTTP/1.0\r\n";
	print INw "Authorization: basic $auth\r\n";
	print INw "Content-length: ",length($in),"\r\n";
	print INw "Content-type: application/x-www-form-urlencoded\r\n";
	print INw "\r\n",$in;
	}
close(INw);
$reply = <OUTr>;
if ($reply =~ /\s401\s/) {
	&ask_password();
	}
$url = "/$module_name/swat.cgi";
while(<OUTr>) {
	s/src="(\/[^"]*)"/src="$url$1"/gi;
	s/href="(\/[^"]*)"/href="$url$1"/gi;
	s/action="(\/[^"]*)"/action="$url$1"/gi;
	print $_;
	}

print "<hr>\n";
&footer("/$module_name/", "share list");

sub ask_password
{
&header("SWAT Login", "");
print "<hr>\n";
if (%swat) {
	print "Your current SWAT username and password are incorrect.\n";
	print "Use the form below to login again. <br>\n";
	}
else {
	print "A username and password are required to login to SWAT.\n";
	print "This can normally be any user on your system. <br>\n";
	}
print "<form action=swat_save.cgi>\n";
print "<center><table border>\n";
print "<tr $tb> <td><b>SWAT Login</b></td> </tr>\n";
print "<tr $cb> <td><table cellpadding=2>\n";
print "<tr> <td><b>Username</b></td>\n";
print "<td><input name=user size=20 value='$swat{'user'}'></td> </tr>\n";
print "<tr> <td><b>Password</b></td>\n";
print "<td><input name=pass size=20 type=password></td> </tr>\n";
print "</table></td></tr></table>\n";
print "<input type=submit value=Login> <input type=reset value=Clear>\n";
print "</center></form><hr>\n";
&footer("", "share list");
exit;
}

