#!/usr/local/bin/perl
# save_pshare.cgi
# Save a new or edited printer share

require './samba-lib.pl';
$whatfailed = "Failed to save printer share";
&ReadParse();
if ($in{old_name}) {
	&get_share($in{old_name});
	}

if ($in{old_name} eq "global") {
	$name = "global";
	}
else {
	# store share options
	$name = $in{printers} ? "printers" : $in{"share"};
	}
#if ($in{"path"} !~ /\S/ && !$in{"printers"}) {
#	&error("No spool directory given");
#	}
&setval("printer", $in{"printer"});
&setval("path", $in{"path"});
&setval("available", $in{"available"});
&setval("browseable", $in{"browseable"});
if ($name ne "global") { &setval("printable", "yes"); }
&setval("comment", $in{"comment"});

# Check for clash
if ($name ne "global") {
	foreach (&list_shares()) {
	        $exists{$_}++;
	        }
	if (!$in{old_name} && $exists{$name}) {
	        &error("A share called '$name' already exists");
	        }
	elsif ($in{old_name} ne $name && $exists{$name}) {
	        &error("A share called '$name' already exists");
	        }
	elsif ($name !~ /^[A-z0-9_\$ ]+$/) {
		&error("'$name' is not a valid share name");
		}
	elsif ($name eq "global") {
		&error("The name 'global' cannot be used for a share");
		}
	}

# Update config file
if ($in{old_name}) {
        # Changing an existing share
        &modify_share($in{old_name}, $name);
        }
else {
        # Creating a new share
        &create_share($name);
        }
&redirect("");

