#!/usr/local/bin/perl
# save_misc.cgi
# Save inputs from conf_misc.cgi

require './samba-lib.pl';
$whatfailed = "Failed to save options";
&ReadParse();
$global = &get_share("global");

&setval("debug level", $in{debug_level}, "");

&setval("getwd cache", $in{getwd_cache}, "no");

if (!$in{lock_directory_def} && !(-d &parent_dir($in{lock_directory}))) {
	&error("The directory containing the lock directory does not exist");
	}
&setval("lock directory", $in{lock_directory_def}?"":$in{lock_directory}, "");

if (!$in{log_file_def} && !(-d &parent_dir($in{log_file}))) {
	&error("The directory containing the log file does not exist");
	}
&setval("log file", $in{log_file_def} ? "" : $in{log_file}, "");

if (!$in{max_log_size_def} && $in{max_log_size} !~ /^\d+$/) {
	&error("'$in{max_log_size}' is not a valid log size");
	}
&setval("max log size", $in{max_log_size_def} ? 0 : $in{max_log_size}, 0);

&setval("read raw", $in{read_raw}, "yes");

&setval("write raw", $in{write_raw}, "yes");

if (!$in{read_size_def} && $in{read_size} !~ /^\d+$/) {
	&error("'$in{read_size}' is not a valid overlapping read size");
	}
&setval("read size", $in{read_size_def} ? 0 : $in{read_size}, 0);

if (!$in{root_directory_def} && !(-d $in{root_directory})) {
	&error("The chroot directory '$in{root_directory}' does not exist");
	}
&setval("root directory", $in{root_directory_def}?"":$in{root_directory}, "");

if (!$in{smbrun_def} && !(-x $in{smbrun})) {
	&error("The smbrun program '$in{smbrun}' does not exist or is ".
	       "not executable");
	}
&setval("smbrun", $in{smbrun_def} ? "" : $in{smbrun}, "");

if (!$in{time_offset_def} && $in{time_offset} !~ /^\d+$/) {
	&error("'$in{time_offset}' is not a valid time offset");
	}
&setval("time offset", $in{time_offset_def} ? 0 : $in{time_offset}, 0);

&setval("read prediction", $in{read_prediction}, "no");

if ($global) { &modify_share("global", "global"); }
else { &create_share("global"); }
&redirect("");

sub parent_dir
{
$_[0] =~ /^(.*\/)[^\/]+$/; return $1;
}
