#!/usr/local/bin/perl
# save_euser.cgi
# Save an existing samba user

require './samba-lib.pl';
&ReadParse();
$whatfailed = "Failed to save user";
@list = &list_users();
$u = $list[$in{'idx'}];

# check inputs
$in{'uid'} =~ /^\d+$/ || &error("'$in{'uid'}' is not a valid Unix UID");
$u->{'uid'} = $in{'uid'};
if ($in{'new'}) {
	$u->{'opts'} = [ split(/\0/, $in{'opts'}) ];
	}
else {
	$in{'realname'} !~ /:/ ||
		&error("Real name cannot contain the character :");
	(-d $in{'homedir'}) ||
		&error("The home directory '$in{'homedir'}' does not exist");
	(-x $in{'shell'}) || &error("$in{'shell'} is not a valid shell");
	$u->{'home'} = $in{'homedir'};
	$u->{'shell'} = $in{'shell'};
	$u->{'real'} = $in{'realname'};
	}

# apply changes
if ($in{ptype} == 0) {
	$u->{'pass1'} = $u->{'$pass2'} = ("X" x 32);
	}
elsif ($in{ptype} == 1) {
	$u->{'pass1'} = "NO PASSWORDXXXXXXXXXXXXXXXXXXXXX";
	$u->{'pass2'} = ("X" x 32);
	}
elsif ($in{ptype} == 3) {
	# changing password.. need to set later with smbpasswd
	$u->{'pass1'} = $u->{'$pass2'} = ("X" x 32);
	$set_passwd = 1;
	}
&modify_user($u);

# Call password change program if necessary
if ($set_passwd) {
	&set_password($u->{'name'}, $in{'pass'}) ||
		&error("Failed to change password using smbpasswd : $error");
	}

&redirect("edit_epass.cgi");

