#!/usr/local/bin/perl
# index.cgi
# Display a list of available samba shares. Special shares (like [homes] and
# [printers]) are included as well.

require './samba-lib.pl';
&header("Samba Share Manager", "", undef, 1, 1);
print "<hr>\n";

if (!-x $config{'samba_server'}) {
	print "The samba server executable <tt>$config{'samba_server'}</tt>\n";
	print "was not found. Either samba is not installed on your system,\n";
	print "or your <a href=\"/config.cgi?$module_name\">module\n";
	print "configuration</a> is incorrect. <p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

# Check the samba version
if (`$config{'samba_server'} -v 2>&1` =~ /(Version|Samba)\s+(\d+)\.(\S+)/i ||
    `$config{'samba_server'} -V 2>&1` =~ /(Version|Samba)\s+(\d+)\.(\S+)/i) {
	# Save version number
	$v1 = $2; $v2 = $3;
	$v2 =~ s/[^0-9]//g;
	$samba_version = "$v1.$v2";
	open(VERSION, ">$module_config_directory/version");
	print VERSION $samba_version,"\n";
	close(VERSION);
	}
else {
	print "Webmin failed to get the version of your samba server\n";
	print "executable <tt>$config{'samba_server'}</tt>. Check your\n";
	print "<a href=\"/config.cgi?$module_name\">module configuation</a>\n";
	print "to make sure this is the correct path. <p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

@empty = &list_shares();
if (!@empty && (-r $config{alt_smb_conf})) {
	# Copy the sample smb.conf file to the real location
	# This is a hack for slackware
	`cp $config{alt_smb_conf} $config{smb_conf} 2>&1`;
	}
if (!(-r $config{smb_conf})) {
	print "The configuration file $config{smb_conf} was not ",
	      "found. Most likely Samba is not installed on your ",
	      "system, or your <a href=\"/config.cgi?$module_name\">module ",
	      "configuration</a> is incorrect.<p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

&get_share("global");
if (&getval("config") || &getval("include")) {
	print "Webmin cannot handle samba config files that use the\n";
	print "<tt>config</tt> or <tt>include</tt> directives.</p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

foreach $s (&list_shares()) {
	$us = "share=".&urlize($s);
	if ($s eq "global") { next; }
	if (!$donefirst) {
		print "<table width=100% border>\n";
		print "<tr $tb> <td><b>Share Name</b></td> <td><b>Path</b></td>\n";
		print "         <td><b>Security</b></td> </tr>\n";
		$donefirst = 1;
		}
	&get_share($s);
	print "<tr $cb>\n";
	if ($cp = &getval("copy")) { $cp = "(copy of <i>$cp</i>)"; }
	if (&istrue("printable")) {
		print "<td><a href=\"edit_pshare.cgi?$us\">$s</a> $cp</td>\n";
		}
	else {
		print "<td><a href=\"edit_fshare.cgi?$us\">$s</a> $cp</td>\n";
		}

	# Output location / path info
	if ($s eq "homes") {
		$p = "<i>All Home Directories</i>";
		}
	elsif ($s eq "printers") {
		$p = "<i>All Printers</i>";
		}
	elsif (&istrue("printable")) {
		$p = &getval("printer") ? "Printer ".&getval("printer")
					: "Default printer";
		}
	else {
		$p = &getval("path");
		}
	print "<td>$p</td>\n";

	# Output security information
	if (&istrue("printable")) {
		if (&getval("valid users")) {
			# Only accessible to some users..
			$sc = "Printable to ".
				&user_list(&getval("valid users"));
			}
		elsif (&istrue("public")) {
			# Accessible to everyone
			$sc = "Printable to everyone";
			}
		else {
			$sc = "Printable to all known users";
			}
		}
	elsif (&istrue("writable")) {
		# Default is read/write access
		if (&istrue("public")) {
			# No password needed..
			$sc = "Read/write to everyone";
			}
		else {
			# Password needed..
			if (&getval("read list")) {
				$sc = "Read only to ".
				      &user_list(&getval("read list")).
				      "<br>Read/write to all other known users";
				}
			else {
				$sc = "Read/write to all known users";
				}
			}
		}
	else {
		# Default is read-only access
		if (&istrue("public")) {
			# No password needed..
			$sc = "Read only to everyone";
			}
		else {
			# Password needed..
			if (&getval("write list")) {
				$sc = "Read/write to ".
				      &user_list(&getval("write list")).
				      "<br>Read only to all other known users";
				}
			else {
				$sc = "Read only to all known users";
				}
			}
		}
	print "<td>$sc</td>\n";
	print "</tr>\n";
	}
if ($donefirst) { print "</table>\n"; }
else { print "<b>No Samba shares defined</b>. <p>\n"; }
print "<a href=\"edit_fshare.cgi\">Create a new file share</a>\n";
print "&nbsp;&nbsp;&nbsp;&nbsp;\n";
print "<a href=\"edit_pshare.cgi\">Create a new printer share</a>\n";
print "&nbsp;&nbsp;&nbsp;&nbsp;\n";
print "<a href=\"create_copy.cgi\">Create a new copy</a>\n";
print "&nbsp;&nbsp;&nbsp;&nbsp;\n";
print "<a href=\"view_users.cgi\">View All Connections</a><p>\n";

print "<hr>\n";
print "<h3>Global Configuration</h3>\n";

@gc_progs = ("conf_net.cgi", "conf_smb.cgi", "conf_pass.cgi",
	     "conf_print.cgi", "conf_misc.cgi", "edit_fshare.cgi?global",
	     "edit_pshare.cgi?global");
@gc_names = ("Unix Networking", "Windows Networking",
	     "Authentication", "Windows to Unix Printing",
	     "Miscellaneous Options", "File Share Defaults",
	     "Printer Share Defaults");
@gc_icons = ("images/icon_0.gif", "images/icon_1.gif", "images/icon_2.gif",
	     "images/icon_3.gif", "images/icon_4.gif", "images/icon_5.gif",
	     "images/icon_6.gif");
if (&has_command($config{'swat_path'})) {
	push(@gc_progs, "swat.cgi");
	push(@gc_names, "SWAT");
	push(@gc_icons, "images/icon_9.gif");
	}
&icons_table(\@gc_progs, \@gc_names, \@gc_icons);

&get_share("global");
if (&istrue("encrypt passwords") && $config{smb_passwd}) {
	# Encrypted passwords are on.. output links
	print "<hr>\n";
	print "<h3>Encrypted Passwords</h3>\n";
	print "<ul>\n";
	print "<li> <a href=edit_epass.cgi>Edit Samba users and\n",
	      "passwords</a>. <p>\n";
	print "<li> <a href=ask_epass.cgi>Convert Unix users to samba\n",
	      "users</a>. <p>\n";
	print "<li> <a href=edit_sync.cgi>Configure automatic Unix and\n",
	      "Samba user synchronisation</a>. <p>\n";
	print "</ul>\n";
	}

&foreign_require("inetd", "inetd-lib.pl");
foreach $inet (&foreign_call("inetd", "list_inets")) {
	$found_inet++ if (($inet->[8] =~ /smbd/ || $inet->[9] =~ /smbd/) &&
			  $inet->[1]);
	}
@smbpids = &find_byname("smbd");
@nmbpids = &find_byname("nmbd");
if (!$found_inet && (!@smbpids || !@nmbpids)) {
	print "<hr>\n";
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"Start Samba Servers\"></td>\n";
	print "<td>The samba servers do not appear to be running\n";
	print "on your system. This means that the shares listed above will\n";
	print "not be accessible to other computers.</td>\n";
	print "</tr></table></form>\n";
	}
elsif (!$found_inet) {
	print "<hr>\n";
	print "<form action=restart.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"Restart Samba Servers\"></td>\n";
	print "<td>Click this button to restart the running samba servers\n";
	print "on your system. This will force the current configuration\n";
	print "to be applied.</td>\n";
	print "</tr></table></form>\n";
	}

print "<hr>\n";
&footer("/", "index");

