#!/usr/local/bin/perl
# ask_epass.cgi
# Display a form asking for password conversion options

require './samba-lib.pl';
&header("Convert Users", "");
print "<hr>\n";

print "This form allows you to synchronize the Unix and Samba user list.\n",
      "When Samba is using <a href=conf_pass.cgi>encrypted passwords</a>,\n",
      "a separate list of users and passwords is used instead of the\n",
      "system user list. <p>\n";

print "<form action=make_epass.cgi>\n";

print "<input type=checkbox name=skip value=1 checked> ",
      "Don't convert or remove these users:";
print "<input name=skip_list size=40 value=\"$config{dont_convert}\"> ",
	&user_chooser_button("skip_list", 1),"<p>\n";

print "<input type=checkbox name=update value=1 checked> ",
      "Update existing Samba users from their Unix details <p>\n";

print "<input type=checkbox name=add value=1 checked> ",
      "Add new Samba users from the Unix user list <p>\n";

print "<input type=checkbox name=delete value=1> ",
      "Delete Samba users who do not exist under Unix <p>\n";

print "<table> <tr>\n";
print "<td valign=top>For newly created users, set the password to:</td>\n";
print "<td><input type=radio name=newmode value=0 checked>No password<br>\n";
print "<input type=radio name=newmode value=1>Account locked<br>\n";
print "<input type=radio name=newmode value=2>Use this password\n",
      "<input type=password name=newpass size=20></td>\n";
print "</tr> </table>\n";

print "<input type=submit value=\"Convert Users\"> </form>\n";

print "<hr>\n";
&footer("", "share list");

