#!/usr/local/bin/perl
# copy_user.cgi
# Copy some user's quota to a number of others

require './quota-lib.pl';
&ReadParse();
$whatfailed = "Failed to copy quotas";
$access{'filesys'} eq "*" ||
	&error("You cannot copy quotas");
&can_edit_user($in{'user'}) ||
	&error("You are not allowed to copy the quotas of this user");

if ($in{'dest'} == 0) {
	# Copy to all users
	setpwent();
	while(@uinfo = getpwent()) {
		push(@copyto, $uinfo[0]);
		}
	endpwent();
	}
elsif ($in{'dest'} == 1) {
	# Copy to selected users
	@copyto = split(/\s+/, $in{'users'});
	}
elsif ($in{'dest'} == 2) {
	# Copy to members of groups
	setpwent();
	while(@uinfo = getpwent()) { $ingroup{$uinfo[3]} .= "$uinfo[0] "; }
	endpwent();
	foreach $g (split(/\s+/, $in{'groups'})) {
		@ginfo = getgrnam($g);
		push(@copyto, split(/\s+/, $ingroup{$ginfo[2]}));
		push(@copyto, split(/\s+/, $ginfo[3]));
		}
	}
@copyto = &unique(@copyto);
@copyto = grep { $_ ne $in{'user'} } @copyto;
if (!@copyto) { &error("No users to copy to"); }
foreach $c (@copyto) {
	&can_edit_user($c) ||
		&error("You are not allowed to copy quotas to '$c'");
	}

# Do the copy
&copy_user_quota($in{'user'}, @copyto);
&redirect("user_filesys.cgi?user=$in{'user'}");

