#!/usr/local/bin/perl
# search.cgi
# Search for manual pages, and display a list of matches or an exact page

require './man-lib.pl';
&ReadParse();
$in{'for'} || &error($text{'search_efor'});
&header($text{'search_title'}, "");
print "<hr>\n";

if ($in{'exact'}) {
	# Display one manual page
	$cmd = $in{'section'} ? $config{'man_cmd_sect'} : $config{'man_cmd'};
	$cmd =~ s/PAGE/"$in{'for'}"/;
	$cmd =~ s/SECTION/"$in{'section'}"/;
	$out = `$cmd 2>&1`;
	if ($out =~ /^.*no manual entry/i || $out =~ /^.*no entry/i ||
	    $out =~ /^.*nothing appropriate/i) {
		print "<p><b>",&text('search_noentry', "<tt>$in{'for'}</tt>"),
		      "</b><p>\n";
		}
	else {
		$out =~ s/.\010//g;
		$out =~ s/^(re)?formatting page.*//i;
		$out =~ s/&/&amp;/g;
		$out =~ s/</&lt;/g;
		$out =~ s/>/&gt;/g;
		print "<table border width=100%>\n";
		print "<tr $cb> <td><pre>",$out,"</pre></td> </tr>\n";
		print "</table>\n";
		}
	}
else {
	# Find matching manual pages
	$cmd = $config{'search_cmd'};
	$cmd =~ s/PAGE/"$in{'for'}"/;
	open(MAN, "$cmd |");
	while(<MAN>) {
		if (/(([^,\s]+).*)\s*\((\S+)\)\s+-\s+(.*)/) {
			push(@rv, [ $2, $3, $4, $1 ]) if (!$done{$2,$3,$4}++);
			}
		}
	close(MAN);
	if (@rv) {
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'search_page'}</b></td> ",
		      "<td><b>$text{'search_section'}</b></td> ",
		      "<td><b>$text{'search_desc'}</b></td> </tr>\n";
		foreach $r (@rv) {
			$r->[3] =~ s/^(\S+)\s+(\1)/$1/;
			if (length($r->[3]) > 30) {
				$r->[3] =~ s/^(.{30}[^,\s]*).*/$1 \.\.\./;
				}
			print "<tr $cb>\n";
			print "<td><a href='search.cgi?exact=1&for=$r->[0]&",
			      "section=$r->[1]'>$r->[3]</a></td>\n";
			print "<td>$r->[1]</td>\n";
			print "<td>$r->[2]</td>\n";
			print "</tr>\n";
			}
		print "</table><br>\n";
		}
	else {
		print "<p><b>",&text('search_none', "<tt>$in{'for'}</tt>"),
		      "</b><p>\n";
		}
	}

print "<hr>\n";
&footer("", $text{'index_return'});

