#!/usr/local/bin/perl
# list_jobs.cgi
# List all print jobs on some printer

require './lpadmin-lib.pl';
&ReadParse();
&header($text{'jobs_title'}, "");
print "<hr>\n";

@jobs = &get_jobs($in{'name'});
if (@jobs) {
	print "<h3>",&text('jobs_header', "<tt>$in{'name'}</tt>"),"</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'jobs_id'}</b></td>\n";
	print "<td><b>$text{'jobs_size'}</b></td>\n";
	print "<td><b>$text{'jobs_by'}</b></td>\n";
	if ($jobs[0]->{'when'}) {
		print "<td><b>$text{'jobs_when'}</b></td>\n";
		}
	if ($jobs[0]->{'file'}) {
		print "<td><b>$text{'jobs_file'}</b></td>\n";
		}
	foreach $j (@jobs) {
		print "<tr $cb>\n";
		if (&can_edit_jobs($in{'name'})) {
			print "<td><a href=\"cancel_job.cgi?name=$in{'name'}&",
			      "id=$j->{'id'}\">$j->{'id'}</a></td>\n";
			}
		else {
			print "<td>$j->{'id'}</td>\n";
			}
		if ($j->{'printfile'} && &can_edit_jobs($in{'name'})) {
			print "<td><a href='view_job.cgi?name=$in{'name'}",
			      "&id=$j->{'id'}'>$j->{'size'} bytes</a></td>\n";
			$printfile++;
			}
		else {
			print "<td>$j->{'size'} bytes</td>\n";
			}
		if ($j->{'user'} =~ /^(\S+)\!(\S+)$/) {
			print "<td>$2\@$1</td>\n";
			}
		else { print "<td>$j->{'user'}</td>\n"; }
		if ($j->{'when'}) { print "<td>$j->{'when'}</td>\n"; }
		if ($j->{'file'}) { print "<td>$j->{'file'}</td>\n"; }
		print "</tr>\n";
		}
	print "</table>\n";
	if ($access{'cancel'}) {
		print $printfile ? $text{'jobs_cancelview'}
				 : $text{'jobs_cancel'},"\n";
		}
	print "<p>\n";
	}
else { print "<h3>",&text('jobs_none', "<tt>$in{'name'}</tt>"),"</h3>\n"; }

print "<hr>\n";
&footer("", $text{'index_return'});


