#!/usr/bin/perl

do "../web-lib.pl";

&init_config();
%access = &get_module_acl();
$| = 1;

sub p_link
{
    my ( $dest, $text ) = @_;
    return "<a href=\"". $dest. "\">". $text. "</a>";
}

sub p_radio
{
    my ( $name, $checked, @list ) = @_;
    local $out, $size = @list, $i = 0;

    do
    {
	$out .= " <input type=radio name=".$name." value=".$list[$i];
	$out .= " checked" if( $checked eq $list[$i++] );
	$out .="> ".$list[$i++];
    } while( $i < $size );

    return $out;
}

sub p_entry
{
    my ( $name, $value, $size ) = @_;
    my $q = $_[1] =~ /'/ ? "\"" : "'";

    $size ? return "<input name=". $name. " size=". $size." value=$q". $value."$q>" : return "<input name=". $name. " value=$q". $value."$q>";
}

sub p_select_wdl
{
    my ( $name, $selected, @list ) = @_;
    local $size = @list, $i = 0, $out = " <select name=".$name.">";
    do
    {
	$out .= "<option name=".$name." value=".$list[$i];
	$out .= " selected" if( $selected eq $list[$i++] );
	$out .= ">".$list[$i++];
    } while( $i < $size );
    $out .= "</select>";

    return $out;
}

sub p_select
{
    my ( $name, $selected, @list ) = @_;
    local @newlist, $item;

    foreach $item ( @list )
    {
	push( @newlist, $item, $item );
    }

    p_select_wdl( $name, $selected, @newlist );
}

sub p_button
{
    my ( $name, $value ) = @_;
    return "<input type=submit name=". $name. " value=\"". $value. "\">";
}
