#!/usr/local/bin/perl
# save_serv.cgi
# Save or create an internet service. This can be called N ways
#  - create a new services file entry
#  - create a new inetd.conf entry (and maybe update or add to services file)
#  - update inetd.conf (and maybe services)
#  - remove an entry from inetd.conf (and maybe change services)

require './inetd-lib.pl';
$whatfailed = "Failed to save internet service";
&ReadParse();

# Check inputs
$in{'name'} =~ /^[A-z][A-z0-9\_\-]+$/ ||
	&error("$in{'name'} is not a valid service name");
$in{'port'} =~ /^[0-9]*$/ || &error("$in{'port'} is not a valid port number");
if ($in{'port'} <= 0 || $in{'port'} > 65535) {
	&error("Port number $in{'port'} must be >0 and <65536");
	}
if ($in{'act'} && $in{'serv'} == 2) {
	$in{'program'} =~ /^\/\S+$/ ||
		&error("'$in{program}' is not a valid program");
	if ($in{'act'} == 2) {
		(-r $in{'program'}) ||
			&error("'$in{'program'}' does not exist");
		(-x $in{'program'}) ||
			&error("'$in{'program'}' is not executable");
		}
	$in{'args'} =~ /^\S+/ ||&error("'$in{'args'}' is not a valid arg list");
	}
elsif ($in{'act'} && $in{serv} == 3) {
	$in{tcpd} =~ /^\S+$/ ||
		&error("'$in{tcpd}' is not a valid TCP-wrappers service");
	}
if ($in{'act'}) {
	$in{'user'} || &error("You must select a user");
	}
if ($config{'extended_inetd'} && !$in{'permin_def'} && $in{'permin'}!~/^\d+$/) {
	&error("'$in{'permin'}' is not a valid maximum per minute");
	}
if ($config{'extended_inetd'} == 2 &&
    !$in{'child_def'} && $in{'child'} !~ /^\d+$/) {
	&error("'$in{'child'}' is not a valid number of child processes");
	}

# Build argument list
@sargs = ($in{'name'}, $in{'port'}, $in{'protocol'},
	  join(' ', split(/\s+/, $in{'aliases'})) );
@iargs = ($in{'act'} == 2, $in{'name'},
	  $in{'protocol'} eq "tcp" ? "stream" : "dgram", $in{'protocol'});
$wait = $in{'wait'}; $user = $in{'user'};
if ($config{'extended_inetd'} == 1) {
	if (!$in{'permin_def'}) { $wait .= ".$in{'permin'}"; }
	if ($in{'group'}) { $user .= ".$in{'group'}"; }
	}
elsif ($config{'extended_inetd'} == 2) {
	if (!$in{'child_def'}) { $wait .= "/$in{'child'}"; }
	if (!$in{'permin_def'} && $in{'child_def'}) {
		&error("If a maximum per minute is given, so must a number ",
		       "of child processes");
		}
	if (!$in{'permin_def'}) { $wait .= "/$in{'permin'}"; }
	if ($in{'group'}) { $user .= ":$in{'group'}"; }
	if ($in{'class'}) { $user .= "/$in{'class'}"; }
	}
push(@iargs, $wait);
push(@iargs, $user);
if ($in{'serv'} == 1) { push(@iargs, "internal"); }
elsif ($in{serv} == 2) {
	push(@iargs, $in{'program'});
	push(@iargs, $in{'args'});
	}
elsif ($in{serv} == 3) {
	push(@iargs, $config{'tcpd_path'});
	push(@iargs, $in{'tcpd'});
	$iargs[$#iargs] .= " $in{'args2'}" if ($in{'args2'});
	}

@servs = &list_services();
@inets = &list_inets();
foreach $s (@servs) {
	if ($s->[1] eq $sargs[0] && $s->[3] eq $sargs[2]) { $same_name = $s; }
	if ($s->[2] == $sargs[1] && $s->[3] eq $sargs[2]) { $same_port = $s; }
	}

if ($in{'spos'} =~ /\d/) {
	# Changing a service..
	@old_serv = @{$servs[$in{'spos'}]};
	if ($in{'ipos'} =~ /\d/) {
		@old_inet = @{$inets[$in{'ipos'}]};
		}
	if ($old_serv[1] ne $sargs[0] || $old_serv[2] != $sargs[1] ||
	    $old_serv[3] ne $sargs[2]) {
		if ($same_name && $same_name->[2] != $old_serv[2]) {
			&error("A service with name $sargs[0] and protocol ".
		       	       "$sargs[2] already exists");
			}
		if ($same_port && $same_port->[1] ne $old_serv[1]) {
			&error("A service using port $sargs[1] and protocol ".
			       "$sargs[2] already exists");
			}
		}
	&modify_service($old_serv[0], @sargs);
	if ($in{'act'} && @old_inet) {
		# modify inetd
		&modify_inet($old_inet[0], @iargs);
		}
	elsif ($in{'act'} && !@old_inet) {
		# add to inetd
		&create_inet(@iargs);
		}
	elsif (!$in{'act'} && @old_inet) {
		# remove from inetd
		&delete_inet($old_inet[0]);
		}
	}
else {
	# Creating a new service...
	# Check for a service with the same name or port and protocol
	if ($same_name) {
		&error("A service with name $sargs[0] and protocol ".
		       "$sargs[2] already exists");
		}
	if ($same_port) {
		&error("A service using port $sargs[1] and protocol ".
		       "$sargs[2] already exists");
		}
	# Check for an existing internet service
	if ($in{'act'}) {
		foreach $i (@inets) {
			if ($i->[3] eq $iargs[1] && $i->[5] eq $iargs[3]) {
				&error("An internet service with name $i->[3] ".
				       "and protocol $i->[5] already exists");
				}
			}
		}
	&create_service(@sargs);
	if ($in{'act'}) { &create_inet(@iargs); }
	}
&redirect("");

