#!/usr/local/bin/perl
# save_rpc.cgi

require './inetd-lib.pl';
$whatfailed = "Failed to save RPC program";
&ReadParse();

# Check inputs
$in{name} =~ /^[A-z][A-z0-9\_\-]+$/ ||
	&error("$in{name} is not a valid program name");
$in{number} =~ /^[0-9]+$/ ||
	&error("$in{number} is not a valid program number");
if ($in{'act'}) {
	$in{vfrom} =~ /^[0-9]+$/ ||
		&error("$in{vfrom} is not a valid RPC version");
	if ($in{vto} eq "") { $in{vto} = $in{vfrom}; }
	$in{vto} =~ /^[0-9]+$/ ||
		&error("$in{vto} is not a valid RPC version");
	if ($in{vto} < $in{vfrom}) {
		$tmp = $in{vfrom}; $in{vfrom} = $in{vto}; $in{vto} = $tmp;
		}
	if ($in{protocols} eq "") {
		&error("You must choose at least one protocol");
		}
	if (!$in{internal}) {
		$in{program} =~ /^\/.*/ ||
			&error("$in{program} is not a valid program");
		if ($in{'act'} == 2) {
			(-r $in{program}) ||
				&error("$in{program} does not exist");
			(-x $in{program}) ||
				&error("$in{program} is not executable");
			}
		$in{args} =~ /^\S+/ ||
			&error("$in{args} is not a valid command");
		}
	$in{'user'} || &error("You must select a user");
	}

@rargs = ($in{'name'}, $in{'number'}, $in{'aliases'});
$vers = ($in{vfrom} == $in{vto} ? $in{vfrom} : "$in{vfrom}-$in{vto}");
$prots = join(',', split(/\0/, $in{protocols}));
@iargs = ($in{'act'} == 2, "$in{name}/$vers", $in{type}, "rpc/$prots");
if ($config{extended_inetd}) {
	push(@iargs, ($in{permin_def} ? $in{wait} : "$in{wait}.$in{permin}"));
	push(@iargs, ($in{group} ? "$in{user}.$in{group}" : $in{user}));
	}
else {
	push(@iargs, $in{wait});
	push(@iargs, $in{user});
	}
if ($in{internal}) { push(@iargs, "internal"); }
else {
	push(@iargs, $in{program});
	push(@iargs, $in{args});
	}

@rpcs = &list_rpcs();
@inets = &list_inets();
foreach $r (@rpcs) {
	if ($r->[1] eq $rargs[0]) { $same_name = $r; }
	if ($r->[2] == $rargs[1]) { $same_prog = $r; }
	}

if ($in{'rpos'} =~ /\d/) {
	# Changing a program (and maybe inetd entry)
	@old_rpc = @{$rpcs[$in{'rpos'}]};
        if ($in{'ipos'} =~ /\d/) {
		@old_inet = @{$inets[$in{'ipos'}]};
		}
	if ($same_name && $old_rpc[1] ne $rargs[0]) {
		&error("An RPC program called $rargs[0] already exists");
		}
	if ($same_prog && $old_rpc[2] ne $rargs[1]) {
		&error("The RPC program number $rargs[1] is already in use");
		}
	&modify_rpc($old_rpc[0], @rargs);
	if ($in{'act'} && @old_inet) {
		# modify inetd
		&modify_inet($old_inet[0], @iargs);
		}
	elsif ($in{'act'} && !@old_inet) {
		# add to inetd
		&create_inet(@iargs);
		}
	elsif (!$in{'act'} && @old_inet) {
		# remove from inetd
		&delete_inet($old_inet[0]);
		}
	}
else {
	# Creating a new program
	if ($same_name) {
		&error("An RPC program called $rargs[0] already exists");
		}
	if ($same_prog) {
		&error("The RPC program number $rargs[1] is already in use");
		}
	if ($in{'act'}) {
		foreach $i (@inets) {
			if ($i->[2] && $i->[3] eq $rargs[0]) {
				&error("An RPC program called $rargs[0] ".
				       "already exists");
				}
			}
		}
	&create_rpc(@rargs);
	if ($in{'act'}) { &create_inet(@iargs); }
	}
&redirect("");

