#!/usr/local/bin/perl
# save_part.cgi
# Save an existing partition

require './format-lib.pl';
&ReadParse();

# check start and end
@dlist = &list_disks();
@dinfo = split(/\s+/, $dlist[$in{disk}]);
&can_edit_disk($dinfo[0]) || &error("You are not allowed to edit this disk");
@plist = &list_partitions($in{disk});
if ($in{delete}) {
	# unassigning a partition
	$whatfailed = "Failed to delete partition";
	@pinfo = split(/\s+/, $plist[$in{part}]);
	&modify_partition($in{disk}, $in{part}, "unassigned", "wu", "", "");
	&redirect("");
	}
else {
	# changing an existing partition
	$whatfailed = "Failed to save partition";
	$in{start} =~ /^\d+$/ ||
		&error("'$in{start}' is not a valid starting cylinder");
	$in{end} =~ /^\d+$/ ||
		&error("'$in{end}' is not a valid ending cylinder");
	$in{start} >= 0 ||
		&error("The starting cylinder must be >0 1");
	$in{end} < $dinfo[2] ||
		&error("The ending cylinder must be < $dinfo[2]");
	$in{start} < $in{end} ||
		&error("The starting cylinder must be less than the ending");

	# Check for partition overlap..
	#for($i=0; $i<@plist; $i++) {
	#	if ($in{part} != $i) {
	#		# not this partition.. check overlap
	#		@pinfo = split(/\s+/, $plist[$i]);
	#		if ($in{start}>=$pinfo[2] && $in{start}<=$pinfo[3] ||
	#		    $in{end}>=$pinfo[2] && $in{end}<=$pinfo[3]) {
	#			# Overlap!
	#			&error("Overlap detected with partition ".
	#			       "$i ($pinfo[2] - $pinfo[3])");
	#			}
	#		}
	#	}

	# make the change
	$flag = ($in{writable} ? "w" : "r").($in{mountable} ? "m" : "u");
	&modify_partition($in{disk}, $in{part}, $in{tag}, $flag, $in{start}, $in{end});
	&redirect("");
	}

