#!/usr/local/bin/perl
# newfs.cgi
# Create a new filesystem 

require './format-lib.pl';
&ReadParse();
&can_edit_disk($in{'dev'}) || &error("You are not allowed to format this disk");
$whatfailed = "Failed to create filesystem";
$cmd = "newfs";
$cmd .= &opt_check("ufs_a", "number of spare blocks", '\d+', "-a");
$cmd .= &opt_check("ufs_b", "logical block size", '\d+', "-b");
$cmd .= &opt_check("ufs_c", "number of cylinders", '\d+', "-c");
$cmd .= &opt_check("ufs_d", "rotational delay", '\d+', "-d");
$cmd .= &opt_check("ufs_f", "fragment size", '\d+', "-f");
$cmd .= &opt_check("ufs_i", "inode size", '\d+', "-i");
$cmd .= &opt_check("ufs_m", "percentage of reserved space", '\d+', "-m");
$cmd .= &opt_check("ufs_n", "number of rotational positions", '\d+', "-n");
$cmd .= $in{ufs_o} ? " -o $in{ufs_o}" : "";
$cmd .= &opt_check("ufs_r", "disk speed", '\d+', "-r");
$cmd .= &opt_check("ufs_s", "filesystem size", '\d+', "-s");
$cmd .= &opt_check("ufs_t", "number of tracks", '\d+', "-t");
$cmd .= &opt_check("ufs_cb", "number of contiguous blocks", '\d+', "-C");
$in{dev} =~ s/dsk/rdsk/g;
$cmd .= " $in{dev}";

&header("Create Filesystem", "");
print "<hr>\n";

print "Executing command <tt>$cmd</tt> ...<p>\n";
print "<pre>\n";
open(MKFS, "$cmd 2>&1 </dev/null |");
while(<MKFS>) { print; }
close(MKFS);
print "</pre>\n";
if ($?) { print "... <b>command failed!</b> <p>\n"; }
else { print "... command complete. <p>\n"; }

print "<hr>\n";
&footer("", "disk list");
