#!/usr/local/bin/perl
# delete_zone.cgi
# Delete a master or slave zone

require './dns-lib.pl';
&ReadParse();
$conf = &get_config();
$zconf = $conf->[$in{'index'}];
%access = &get_module_acl();
&can_edit_zone(\%access, $zconf->{'values'}->[0]) ||
        &error("You are not allowed to delete this zone");

if ($zconf->{'values'}->[0] !~ /in-addr.arpa/i &&
    $zconf->{'name'} eq 'primary') {
	# find and delete reverse records
	@recs = &read_zone_file($zconf->{'values'}->[1],
				$zconf->{'values'}->[0]);
	foreach $r (@recs) {
		next if ($r->{'type'} ne "A");
		($orevconf, $orevfile, $orevrec) =
			&find_reverse($r->{'values'}->[0]);
		if ($orevrec && &can_edit_reverse($orevconf) &&
		    $r->{'name'} eq $orevrec->{'values'}->[0] &&
		    $r->{'values'}->[0] eq &arpa_to_ip($orevrec->{'name'})) {
			&delete_record($orevrec->{'file'} , $orevrec);
			@orrecs = &read_zone_file(
				$orevfile, $orevconf->{'values'}->[0]);
			&bump_soa_record($orevfile, \@orrecs);
			}
		}
	}

&delete_zone($zconf);
if ($zconf->{'name'} eq "primary") {
	unlink(&absolute_path($zconf->{'values'}->[1]));
	}

# remove from acl files
&read_acl(undef, \%wusers);
foreach $u (keys %wusers) {
        %uaccess = &get_module_acl($u);
        if ($uaccess{'zones'} ne '*') {
                $uaccess{'zones'} =
			join(' ', grep { $_ ne $zconf->{'values'}->[0] }
                                  split(/\s+/, $uaccess{'zones'}));
                &save_module_acl(\%uaccess, $u);
                }
        }
&redirect("");

# can_edit_reverse(&zone)
sub can_edit_reverse
{
return $access{'reverse'} || &can_edit_zone(\%access, $_[0]->{'values'}->[0]);
}

