#!/usr/local/bin/perl
# create_master.cgi
# Create a new master zone

require './bind8-lib.pl';
&ReadParse();
&error_setup($text{'mcreate_err'});
%access = &get_module_acl();
$access{'master'} || &error($text{'mcreate_ecannot'});
$access{'ro'} && &error($text{'master_ero'});
$conf = &get_config();

# validate inputs
if ($in{'rev'}) {
	$in{'zone'} =~ /^[0-9\.]+$/ ||
		&error(&text('mcreate_enet', $in{'zone'}));
	$in{'zone'} = &ip_to_arpa($in{'zone'});
	}
else {
	$in{'zone'} =~ /^[A-z0-9\-\.]+$/ ||
		&error(&text('mcreate_edom', $in{'zone'}));
	$in{'zone'} !~ /^[0-9\.]+$/ ||
		&error(&text('mcreate_edom2', $in{'zone'}));
	}
$in{'zone'} =~ s/\.$//g;
$in{'master'} =~ /^[A-z0-9\-\.]+$/ ||
	&error(&text('master_emaster', $in{'master'}));
if ($in{'master'} !~ /\.$/) { $in{'master'} .= "."; }
$in{'email'} =~ /^\S+$/ ||
	&error(&text('master_eemail', $in{'email'}));
if ($in{'email'} =~ s/\@/\./) { $in{'email'} .= "."; }
$in{'refresh'} =~ /^\S+$/ ||
        &error(&text('master_erefresh', $in{'refresh'}));
$in{'retry'} =~ /^\S+$/ ||
        &error(&text('master_eretry', $in{'retry'}));
$in{'expiry'} =~ /^\S+$/ ||
        &error(&text('master_eexpiry', $in{'expiry'}));
$in{'minimum'} =~ /^\S+$/ ||
        &error(&text('master_eminimum', $in{'minimum'}));
$base = $access{'dir'} eq '/' ? &base_directory($conf) : $access{'dir'};
if (!$in{'file_def'}) {
	$in{'file'} =~ /^\S+$/ ||
		&error(&text('mcreate_efile', $in{'file'}));
	if ($in{'file'} !~ /^\//) {
		$in{'file'} = $base."/".$in{'file'};
		}
	&allowed_zone_file(\%access, $in{'file'}) ||
		&error(&text('mcreate_efile2', $in{'file'}));
	}
elsif ($in{'rev'}) {
	# create filename for reverse zone
	$in{'file'} = $base."/".&arpa_to_ip($in{'zone'}).".rev";
	}
else {
	# create filename for forward zone
	$in{'file'} = $base."/".$in{'zone'}.".hosts";
	}
open(ZONE, "> $in{'file'}") || &error(&text('mcreate_efile3', $in{'file'}, $!));
close(ZONE);

# create the SOA and NS records
if ($config{'soa_style'} == 1) {
        $serial = &date_serial()."00";
        }
else {
        $serial = time();
        }
$vals = "$in{'master'} $in{'email'} (\n".
        "\t\t\t$serial\n".
        "\t\t\t$in{'refresh'}\n".
        "\t\t\t$in{'retry'}\n".
        "\t\t\t$in{'expiry'}\n".
        "\t\t\t$in{'minimum'} )";
&create_record($in{'file'}, "$in{'zone'}.", undef, "IN", "SOA", $vals);
&create_record($in{'file'}, "$in{'zone'}.", undef, "IN", "NS", $in{'master'});

if ($in{'tmpl'}) {
	# Create template records
	&check_ipaddress($in{'ip'}) || &error($text{'master_eip'});
	for($i=0; $config{"tmpl_$i"}; $i++) {
		@c = split(/\s+/, $config{"tmpl_$i"}, 3);
		&create_record($in{'file'},
			       $c[0] eq '.' ? "$in{'zone'}." : $c[0], undef,
			       "IN", $c[1], $c[2] ? $c[2] : $in{'ip'});
		}
	}

# create the zone directive
open(CONF, ">> $config{'named_conf'}");
print CONF "zone \"$in{'zone'}\" {\n";
print CONF "\ttype master;\n";
print CONF "\tfile \"$in{'file'}\";\n";
print CONF "\t};\n";
print CONF "\n";
close(CONF);

# Add the new zone to the access list
if ($access{'zones'} ne '*') {
	$access{'zones'} .= " ".$in{'zone'};
	&save_module_acl(\%access);
	}
&redirect("");

