# mod_proxy.pl
# Editors for proxy directives

sub mod_proxy_directives
{
$rv = [ [ 'ProxyRequests', 0, 13, 'virtual', undef, 11 ],
        [ 'ProxyRemote', 1, 13, 'virtual', undef, 7 ],
        [ 'ProxyPass', 1, 10, 'virtual', undef, 0 ],
        [ 'ProxyBlock', 1, 13, 'virtual', 1.2, 9 ],
        [ 'NoProxy', 1, 13, 'virtual', 1.3, 5 ],
        [ 'ProxyDomain', 0, 13, 'virtual', 1.3, 4 ],
	[ 'AllowCONNECT', 0, 13, 'virtual', 1.302, 2 ],
        [ 'CacheRoot', 0, 13, 'virtual', undef, 10 ],
        [ 'CacheSize', 0, 13, 'virtual' ],
        [ 'CacheGcInterval', 0, 13, 'virtual' ],
        [ 'CacheMaxExpire', 0, 13, 'virtual' ],
        [ 'CacheLastModifiedFactor', 0, 13, 'virtual' ],
        [ 'CacheDirLevels', 0, 13, 'virtual' ],
        [ 'CacheDirLength', 0, 13, 'virtual' ],
        [ 'CacheDefaultExpire', 0, 13, 'virtual' ],
        [ 'CacheForceCompletion', 0, 13, 'virtual', 1.301 ],
        [ 'NoCache', 1, 13, 'virtual', undef, 3 ] ];
return &make_directives($rv, $_[0], "mod_proxy");
}

sub edit_ProxyRequests
{
return (1, "Act as proxy server?", 
        &choice_input($_[0]->{'value'}, "ProxyRequests", "off",
                      "Yes,on", "No,off"));
}
sub save_ProxyRequests
{
return &parse_choice("ProxyRequests", "off");
}

sub edit_ProxyRemote
{
local($rv, $i, $match, $proxy, $max);
$rv = "<table border>\n".
      "<tr $tb> <td><b>Requests</b></td> <td><b>Forward to</b></td> </tr>\n";
$max = @{$_[0]}+1;
for($i=0; $i<$max; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(\S+)$/) {
		$match = $1; $proxy = $2;
		}
	else { $match = "*"; $proxy = ""; }
	$rv .= "<tr $cb>\n";
	$rv .= sprintf
	        "<td><input type=radio name=ProxyRemote_match_all_$i %s> All\n",
	        $match eq "*" ? "checked" : "";
	$rv .= sprintf
	        "<input type=radio name=ProxyRemote_match_all_$i %s> Matching..\n",
	        $match eq "*" ? "" : "checked";
	$rv .= sprintf
	        "<input name=ProxyRemote_match_$i size=30 value=\"%s\"></td>\n",
	        $match eq "*" ? "" : $match;
	$rv .= "<td><input name=ProxyRemote_proxy_$i size=30 ".
	       "value=\"$proxy\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "Requests to pass to another proxy", $rv);
}
sub save_ProxyRemote
{
local($i, $match, $match_all, $proxy, @rv);
for($i=0; defined($proxy = $in{"ProxyRemote_proxy_$i"}); $i++) {
	$match = $in{"ProxyRemote_match_$i"};
	$match_all = $in{"ProxyRemote_match_all_$i"};
	if ($match !~ /\S/ && $proxy !~ /\S/) { next; }
	if ($match_all) { $match = "*"; }
	elsif ($match !~ /^\S+$/) { &error("'$match' is not a valid request"); }
	$proxy =~ /^http:\/\/\S+$/ || &error("'$proxy' is not a valid proxy URL");
	push(@rv, "$match $proxy");
	}
return ( \@rv );
}

sub edit_ProxyPass
{
local($rv, $i, $path, $url, $max);
$rv = "<table border>\n".
      "<tr $tb> <td><b>Local URL path</b></td> <td><b>Remote URL</b></td> </tr>\n";
$max = @{$_[0]} + 1;
for($i=0; $i<$max; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(\S+)$/) {
		$path = $1; $url = $2;
		}
	else { $path = $url = ""; }
	$rv .= "<tr $cb>\n";
	$rv .= "<td><input name=ProxyPass_path_$i size=20 value=\"$path\"></td>\n";
	$rv .= "<td><input name=ProxyPass_url_$i size=30 value=\"$url\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "Proxy local to remote URLs", $rv);
}
sub save_ProxyPass
{
local($i, $url, $path, @rv);
for($i=0; defined($path = $in{"ProxyPass_path_$i"}); $i++) {
	$url = $in{"ProxyPass_url_$i"};
	if ($path !~ /\S/ && $url !~ /\S/) { next; }
	$path =~ /^\/\S*$/ || &error("'$path' is not a valid local URL path");
	$url =~ /^http:\/\/(\S+)$/ || &error("'$url' is not a valid remote URL");
	push(@rv, "$path $url");
	}
return ( \@rv );
}

sub edit_ProxyBlock
{
local($b, @b);
foreach $b (@{$_[0]}) { push(@b, split(/\s+/, $b->{'value'})); }
return (2, "Block requests to domains",
        &opt_input(@b ? join(' ', @b) : undef, "ProxyBlock", "None", 50));
}
sub save_ProxyBlock
{
return &parse_opt("ProxyBlock", '\S', "No domains given to block");
}

sub edit_NoProxy
{
local($n, @n, $i, $rv);
foreach $n (@{$_[0]}) { push(@n, split(/\s+/, $n->{'value'})); }
$rv = "<table border>\n".
      "<tr $tb> <td><b>Type</b></td> <td><b>No proxy for..</b></td> </tr>\n";
for($i=0; $i<=@n; $i++) {
	$rv .= "<tr $cb>\n";
	if ($i>=@n) { $type = 0; }
	elsif ($n[$i] =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
		if ($4 == 0) { $type = 3; }
		else { $type = 0; }
		}
	elsif ($n[$i] =~ /^([0-9\.]+)\/(\d+)$/) { $type = 4; }
	elsif ($n[$i] =~ /^([0-9\.]+)$/) { $type = 3; }
	elsif ($n[$i] =~ /^\.(\S+)$/) { $type = 2; }
	else { $type = 1; }
	$rv .= "<td>".&select_input($type, "NoProxy_type_$i", 0, "IP address,0",
	        "Hostname,1", "Domain,2", "IP network,3", "Network/bits,4")."</td>\n";
	$rv .= "<td><input name=NoProxy_for_$i size=30 value=\"$n[$i]\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "Don't pass requests to another proxy for", $rv);
}
sub save_NoProxy
{
local($i, $type, $for, @rv);
for($i=0; defined($type = $in{"NoProxy_type_$i"}); $i++) {
	$for = $in{"NoProxy_for_$i"};
	if ($for !~ /\S/) { next; }
	if ($type == 0) {
		&check_ipaddress($for) || 
			&error("'$for' is not a valid IP address");
		}
	elsif ($type == 1) {
		$for =~ /^[A-z0-9\-][A-z0-9\-\.]+[A-z0-9\-]$/ ||
			&error("'$for' is not a valid hostname");
		}
	elsif ($type == 2) {
		$for =~ /^\.[A-z0-9\-\.]+[A-z0-9\-]$/ ||
			&error("'$for' is not a valid domain");
		}
	elsif ($type == 3) {
		if ($for =~ /^(\d+)$/) { $for .= ".0.0.0"; }
		elsif ($for =~ /^(\d+)\.(\d+)$/) { $for .= ".0.0"; }
		elsif ($for =~ /^(\d+)\.(\d+)\.(\d+)$/) { $for .= ".0"; }
		&check_ipaddress($for) || &error("'$for' is not a valid network");
		}
	elsif ($type == 4) {
		($for =~ /^(\S+)\/(\d+)$/ && &check_ipaddress($1) && $2 < 32) ||
			&error("'$for' is not a valid network/bits pair");
		}
	push(@rv, $for);
	}
return @rv ? ( [ join(' ', @rv) ] ) : ( [ ] );
}

sub edit_ProxyDomain
{
return (1, "Domain for requests with no domain",
        &opt_input($_[0]->{'value'}, "ProxyDomain", "None", 20));
}
sub save_ProxyDomain
{
return &parse_opt("ProxyDomain", '^[A-z0-9\-]+$', "Invalid default domain");
}

sub edit_AllowCONNECT
{
return (1, "Ports to which CONNECT is allowed",
        &opt_input($_[0]->{'value'}, "AllowCONNECT", "Default", 10));
}
sub save_AllowCONNECT
{
return &parse_opt("AllowCONNECT", '^[\d ]+$', "Invalid CONNECT ports");
}

sub edit_CacheRoot
{
return (1, "Cache directory",
        &opt_input($_[0]->{'value'}, "CacheRoot", "None", 20).
        &file_chooser_button("CacheRoot", 0));
}
sub save_CacheRoot
{
$in{'CacheRoot_def'} || &allowed_auth_file($in{'CacheRoot'}) ||
	&error("cache directory is not under the allowed directory");
return &parse_opt("CacheRoot", '^\S+$', "Invalid cache directory name");
}

sub edit_CacheSize
{
return (1, "Cache size",
        &opt_input($_[0]->{'value'}, "CacheSize", "Default", 8)." Kb");
}
sub save_CacheSize
{
return &parse_opt("CacheSize", '^\d+$', "Invalid cache size");
}

sub edit_CacheGcInterval
{
return (1, "Cache garbage collection interval",
        &opt_input($_[0]->{'value'}, "CacheGcInterval", "Never", 6)." hours");
}
sub save_CacheGcInterval
{
return &parse_opt("CacheGcInterval", '^\d+$',
                  "Invalid cache garbage collection interval");
}

sub edit_CacheMaxExpire
{
return (1, "Cached file maximum expiry time",
        &opt_input($_[0]->{'value'}, "CacheMaxExpire", "Default", 6)." hours");
}
sub save_CacheMaxExpire
{
return &parse_opt("CacheMaxExpire", '^\d+$',
                  "Invalid cached file maximum expiry time");
}

sub edit_CacheLastModifiedFactor
{
return (1, "Cached file expiry time factor",
        &opt_input($_[0]->{'value'}, "CacheLastModifiedFactor", "Default", 6));
}
sub save_CacheLastModifiedFactor
{
return &parse_opt("CacheLastModifiedFactor", '^\d+$',
                  "Invalid cached file expiry time factor");
}

sub edit_CacheDirLevels
{
return (1, "Cache directory levels",
        &opt_input($_[0]->{'value'}, "CacheDirLevels", "Default", 6));
}
sub save_CacheDirLevels
{
return &parse_opt("CacheDirLevels", '^\d+$',
                  "Invalid number of cache directory levels");
}

sub edit_CacheDirLength
{
return (1, "Cache directory name length",
        &opt_input($_[0]->{'value'}, "CacheDirLength", "Default", 4));
}
sub save_CacheDirLength
{
return &parse_opt("CacheDirLength", '^\d+$',
                  "Invalid cache directory name length");
}

sub edit_CacheDefaultExpire
{
return (1, "Cache default expiry time",
        &opt_input($_[0]->{'value'}, "CacheDefaultExpire", "Default", 6).
	" hours");
}
sub save_CacheDefaultExpire
{
return &parse_opt("CacheDefaultExpire", '^\d+$', "Invalid default expiry time");
}

sub edit_CacheForceCompletion
{
return (1, "Finish and cache transfer after",
        &opt_input($_[0]->{'value'}, "CacheForceCompletion", "Default", 6)."%");
}
sub save_CacheForceCompletion
{
return &parse_opt("CacheForceCompletion", '^\d+$',
		  "Invalid transfer percentage");
}

sub edit_NoCache
{
local($n, @n);
foreach $n (@{$_[0]}) { push(@n, $n->{'value'}); }
return (1, "Domains not to cache",
        &opt_input(@n ? join(' ', @n) : undef, "NoCache", "None", 20));
}
sub save_NoCache
{
return &parse_opt("NoCache", '\S', "No domains not to cache given");
}

1;

