# mod_mime.pl
# Defines MIME module directives

sub mod_mime_directives
{
$rv = [ [ 'AddType', 1, 6, 'virtual directory htaccess', undef, 10 ],
	[ 'AddHandler', 1, 6, 'virtual directory htaccess', undef, 6 ],
	[ 'RemoveHandler', 1, 6, 'directory htaccess', 1.304, 5 ],
	[ 'AddLanguage', 1, 6, 'virtual directory htaccess', undef, 4 ],
	[ 'AddEncoding', 1, 6, 'virtual directory htaccess', undef, 8 ],
	[ 'AddCharset', 1, 6, 'virtual directory htaccess', 1.310, 2 ],
	[ 'ForceType', 0, 6, 'directory htaccess' ],
	[ 'SetHandler', 0, 6, 'directory htaccess' ],
	[ 'TypesConfig', 0, 6, 'global' ] ];
return &make_directives($rv, $_[0], "mod_mime");
}

# extmap_input(directive, title, size, desc, list)
sub extmap_input
{
local($rv, $i, $type, $exts);
$rv = "<table border>\n".
      "<tr $tb> <td><b>$_[1]</b></td> <td><b>Extensions</b></td>\n".
      "<td><b>$_[1]</b></td> <td><b>Extensions</b></td> </tr>\n";
$len = int(@{$_[4]}/2)*2 + 2;
for($i=0; $i<$len; $i++) {
	if ($i%2 == 0) { $rv .= "<tr $cb>\n"; }
	if ($_[4]->[$i]) {
		$_[4]->[$i]->{'value'} =~ /^(\S+)\s*(.*)$/;
		$type = $1; $exts = $2;
		}
	else { $type = $exts = ""; }
	$rv .= "<td>";
	if ($_[2] eq "h") { $rv .= &handler_input($type, "$_[0]_type_$i"); }
	else { $rv .= "<input name=$_[0]_type_$i size=$_[2] value=$type>"; }
	$rv .= "</td>\n";
	$rv .= "<td><input name=$_[0]_exts_$i size=10 value=\"$exts\"></td>\n";
	if ($i%2 == 1) { $rv .= "</tr>\n"; }
	}
$rv .= "</table>\n";
return (2, $_[3], $rv);
}

# parse_extmap(directive, regexp, desc)
sub parse_extmap
{
local($i, $type, $exts, @rv, $re); $re = $_[1];
for($i=0; defined($in{"$_[0]_type_$i"}); $i++) {
	$type = $in{"$_[0]_type_$i"}; $exts = $in{"$_[0]_exts_$i"};
	if ($type !~ /\S/ && $exts !~ /\S/) { next; }
	if ($type !~ /$re/) { &error("'$type' is not a valid $_[2]"); }
	if ($exts !~ /\S/) { &error("No extensions given for $_[2] $type"); }
	push(@rv, "$type $exts");
	}
return ( \@rv );
}

sub edit_AddType
{
&extmap_input("AddType", "Type", 20, "Extra MIME types", $_[0]);
}
sub save_AddType
{
return &parse_extmap("AddType", '^(\S+)\/(\S+)$',
		     "MIME type");
}

sub edit_AddHandler
{
&extmap_input("AddHandler", "Handler", "h", "Content handlers", $_[0]);
}
sub save_AddHandler
{
return &parse_extmap("AddHandler");
}

sub edit_AddEncoding
{
&extmap_input("AddEncoding", "Encoding", 20, "Content encodings", $_[0]);
}
sub save_AddEncoding
{
return &parse_extmap("AddEncoding", '^(\S+)$',
		     "Content encoding");
}

sub edit_AddLanguage
{
&extmap_input("AddLanguage", "Language", 5, "Content languages", $_[0]);
}
sub save_AddLanguage
{
return &parse_extmap("AddLanguage", '^\S+$', "Content language");
}

sub edit_ForceType
{
return (1, "Treat all files as MIME type",
	&opt_input($_[0]->{'value'}, "ForceType", "Real type", 15));
}
sub save_ForceType
{
return &parse_opt("ForceType", '^\S+\/\S+$', "Invalid MIME type");
}

sub edit_SetHandler
{
return (1, "Pass all files to handler",
	&handler_input($_[0]->{'value'}, "SetHandler"));
}
sub save_SetHandler
{
return &parse_handler("SetHandler");
}

sub edit_TypesConfig
{
return (2,
	"MIME types file",
	&opt_input($_[0]->{'value'}, "TypesConfig", "Default", 40).
	&file_chooser_button("TypesConfig", 0));
}
sub save_TypesConfig
{
return &parse_opt("TypesConfig");
}

sub edit_RemoveHandler
{
foreach $v (@{$_[0]}) {
	push(@list, @{$v->{'words'}});
	}
return (2, "Ignore handlers for extensions",
	&opt_input(@list ? join(" ", @list) : undef,
		   "RemoveHandler", "None", 40));
}
sub save_RemoveHandler
{
return &parse_opt("RemoveHandler");
}

sub edit_AddCharset
{
&extmap_input("AddCharset", "Charset", 5, "Extra character sets", $_[0]);
}
sub save_AddCharset
{
return &parse_extmap("AddCharset");
}

1;

