# mod_imap.pl
# Defines editors for imagemap directives

sub mod_imap_directives
{
$rv = [ [ 'ImapMenu', 0, 5, 'virtual directory htaccess' ],
        [ 'ImapDefault', 0, 5, 'virtual directory htaccess' ],
        [ 'ImapBase', 0, 5, 'virtual directory htaccess' ] ];
return &make_directives($rv, $_[0], "mod_imap");
}

sub mod_imap_handlers
{
return ("imap-file");
}

sub edit_ImapMenu
{
return (2, "Action on incorrect use of imagemaps",
        &select_input($_[0]->{'value'}, "ImapMenu", "", "Default,",
         "Go to default URL,none", "Show formatted menu,formatted",
         "Show semi-formatted menu,semiformatted",
         "Show unformatted menu,unformatted"));
}
sub save_ImapMenu
{
return &parse_select("ImapMenu", "");
}

sub edit_ImapDefault
{
local($rv, $v);
if ($_[0]->{'value'} =~ /^\S+:/) { $v = "url"; }
else { $v = $_[0]->{'value'}; }
$rv = &select_input($v, "ImapDefault", "", "Default,",
       "Display server error,error",  "Do nothing,nocontent",
       "Go to imagemap URL,map", "Go to referring URL,referer",
       "Go to URL...,url");
$rv .= sprintf "&nbsp;<input name=ImapDefault_url size=30 value=\"%s\">\n",
        $v eq "url" ? $_[0]->{'value'} : "";
return (2, "Default action for imagemaps", $rv);
}
sub save_ImapDefault
{
if ($in{'ImapDefault'} eq "") { return ( [ ] ); }
elsif ($in{'ImapDefault'} ne "url") { return ( [ $in{'ImapDefault'} ] ); }
elsif ($in{'ImapDefault_url'} !~ /^\S+$/) {
	&error("'$in{'ImapDefault_url'}' is not a valid URL");
	}
else { return ( [ $in{'ImapDefault_url'} ] ); }
}

sub edit_ImapBase
{
local($rv, $v);
if ($_[0]->{'value'} =~ /^\S+:/) { $v = "url"; }
else { $v = $_[0]->{'value'}; }
$rv = &select_input($v, "ImapBase", "", "Default,",
       "Server root,root", "Imagemap URL,map",
       "Referring URL,referer", "URL...,url");
$rv .= sprintf "&nbsp;<input name=ImapBase_url size=30 value=\"%s\">\n",
        $v eq "url" ? $_[0]->{'value'} : "";
return (2, "Default base for imagemaps", $rv);
}
sub save_ImapBase
{
if ($in{'ImapBase'} eq "") { return ( [ ] ); }
elsif ($in{'ImapBase'} ne "url") { return ( [ $in{'ImapBase'} ] ); }
elsif ($in{'ImapBase_url'} !~ /^\S+$/) {
	&error("'$in{'ImapBase_url'}' is not a valid URL");
	}
else { return ( [ $in{'ImapBase_url'} ] ); }
}

1;

