# mod_actions.pl
# Defines editors for CGI actions

sub mod_actions_directives
{
$rv = [ [ 'Action', 1, 11, 'virtual directory htaccess', undef, 5 ],
        [ 'Script', 1, 11, 'virtual directory' ] ];
return &make_directives($rv, $_[0], "mod_actions");
}

sub mod_actions_handlers
{
local($d, @rv);
foreach $d (&find_all_directives($_[0], "Action")) {
	if ($d->{'words'}->[0] =~ /^[A-z0-9\-\_]+$/) {
		push(@rv, $d->{'words'}->[0]);
		}
	}
return @rv;
}

sub edit_Action
{
local($rv, $len, $i, $type, $cgi);
$rv = "<table border>\n".
      "<tr $tb> <td><b>Handler / MIME type</b></td> <td><b>CGI script URL</b></td> </tr>";
$len = @{$_[0]}+1;
for($i=0; $i<$len; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(\S+)$/) {
		$type = $1; $cgi = $2;
		}
	else { $type = $cgi = ""; }
	$rv .= "<tr $cb>\n";
	$rv .= "<td><input name=Action_type_$i size=20 value=\"$type\"></td>\n";
	$rv .= "<td><input name=Action_cgi_$i size=40 value=\"$cgi\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "Handler or MIME type CGI actions", $rv);
}
sub save_Action
{
local($i, $cgi, $type, @rv);
for($i=0; defined($in{"Action_type_$i"}); $i++) {
	$type = $in{"Action_type_$i"}; $cgi = $in{"Action_cgi_$i"};
	if ($type !~ /\S/ && $cgi !~ /\S/) { next; }
	$type =~ /^(\S+)$/ || &error("'$type' is not a valid handler or MIME type");
	$cgi =~ /^\/(\S+)$/ || &error("'$cgi' is not a valid CGI script");
	push(@rv, "$type $cgi");
	}
return ( \@rv );
}

sub edit_Script
{
local($rv, $len, $i, $meth, $cgi, $m, $found);
$rv = "<table border>\n".
      "<tr $tb> <td><b>HTTP method</b></td> <td><b>CGI script</b></td> </tr>";
$len = @{$_[0]}+1;
for($i=0; $i<$len; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(\S+)$/) {
		$meth = $1; $cgi = $2;
		}
	else { $meth = $cgi = ""; }
	$rv .= "<tr $cb><td><select name=Script_meth_$i>\n";
	foreach $m ("", "GET", "POST", "PUT", "DELETE") {
		$rv .= sprintf "<option %s>$m\n", $meth eq $m ? "selected" : "";
		$found++ if ($meth eq $m);
		}
	printf "<option selected>$meth\n" if (!$found);
	$rv .= "</select></td>\n";
	$rv .= "<td><input name=Script_cgi_$i size=40 value=\"$cgi\"></td>\n";
	$rv .= "</tr>\n";
	}
$rv .= "</table>\n";
return (2, "HTTP method CGI actions", $rv);
}
sub save_Script
{
local($i, @rv, $meth, $cgi);
for($i=0; defined($in{"Script_meth_$i"}); $i++) {
	$meth = $in{"Script_meth_$i"}; $cgi = $in{"Script_cgi_$i"};
	if (!$meth && $cgi !~ /\S/) { next; }
	$meth || &error("No method chosen for CGI script '$cgi'");
	$cgi =~ /^\/(\S+)$/ || &error("'$cgi' is not a valid CGI script");
	push(@rv, "$meth $cgi");
	}
return ( \@rv );
}

1;

