#!/usr/local/bin/perl
# index.cgi
# List all webmin users

require './acl-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1);

@ulist = &list_users();
foreach $u (@ulist) {
	$me = $u if ($u->{'name'} eq $ENV{'REMOTE_USER'});
	}
@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
	$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
			       &list_modules();
map { $mcan{$_}++ } @mcan;

foreach $m (&list_modules()) {
	@minfo = &module_info($m);
	$modname{$m} = $minfo[2];
	}
foreach $u (@ulist) {
	next if (!&can_edit_user($u->{'name'}));
	if (!$header) {
		print "<hr>\n";
		print "<table border width=100%>\n";
		print "<tr $tb> <td><b>$text{'index_user'}</b></td>\n";
		print "<td><b>$text{'index_modules'}</b></td> </tr>\n";
		$header++;
		}
	print "<tr $cb>\n";
	printf "<td valign=top><a href=\"edit_user.cgi?user=%s\">%s</a></td>\n",
		&urlize($u->{'name'}), $u->{'name'};
	print "<td><table width=100%>\n";
	$sw = 0;
	foreach $m (@{$u->{'modules'}}) {
		if ($modname{$m}) {
			if (!$sw) { print "<tr>\n"; }
			print "<td width=50%>";
			if ($mcan{$m}) {
				print "<a href='edit_acl.cgi?mod=",&urlize($m),
				      "&user=",&urlize($u->{'name'}),
				      "'>$modname{$m}</a>";
				}
			else {
				print $modname{$m};
				}
			print "</td>\n";
			if ($sw) { print "<tr>\n"; }
			$sw = !$sw;
			}
		}
	print "</td></table> </tr>\n";
	}
print "</table>\n" if ($header);
print "<a href=edit_user.cgi>$text{'index_create'}</a>. <p>\n"
	if ($access{'create'});

&get_miniserv_config(\%miniserv);
if (uc($ENV{'HTTPS'}) eq "ON" && $miniserv{'ca'}) {
	print "<hr>\n";
	print "<form action=cert_form.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value='$text{'index_cert'}'></td>\n";
	print "<td>$text{'index_certmsg'}</td>\n";
	print "</table></tr></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});


