#!/usr/local/bin/perl
# edit_user.cgi
# Edit a new or existing webmin user

require './acl-lib.pl';
&ReadParse();
if ($in{'user'}) {
	# Editing an existing user
	&can_edit_user($in{'user'}) || &error($text{'edit_euser'});
	&header($text{'edit_title'}, "");
	foreach $u (&list_users()) {
		if ($u->{'name'} eq $in{'user'}) {
			%user = %$u;
			}
		if ($u->{'name'} eq $ENV{'REMOTE_USER'}) {
			$me = $u;
			}
		}
	}
else {
	# Creating a new user
	$access{'create'} || &error($text{'edit_ecreate'});
	&header($text{'edit_title2'}, "");
	foreach $u (&list_users()) {
		if ($u->{'name'} eq $in{'clone'}) {
			$user{'modules'} = $u->{'modules'};
			$user{'lang'} = $u->{'lang'};
			}
		if ($u->{'name'} eq $ENV{'REMOTE_USER'}) {
			$me = $u;
			}
		}
	}
print "<hr>\n";

print "<form action=save_user.cgi>\n";
if ($in{'user'}) {
	print "<input type=hidden name=old value=\"$user{'name'}\">\n";
	print "<input type=hidden name=oldpass value=\"$user{'pass'}\">\n";
	}
if ($in{'clone'}) {
	print "<input type=hidden name=clone value=\"$in{'clone'}\">\n";
	}
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_rights'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'edit_user'}</b></td>\n";
if ($access{'rename'} || !$in{'user'}) {
	print "<td><input name=name size=25 ",
	      "value=\"$user{'name'}\"></td> </tr>\n";
	}
else {
	print "<td>$user{'name'}</td>\n";
	}

print "<tr> <td><b>$text{'edit_pass'}</b></td> <td>\n";
printf "<input type=radio name=pass_def value=2 %s> $text{'edit_same'}\n",
	$user{'sync'} ? "checked" : "";
if ($in{'user'}) {
	printf "<input type=radio name=pass_def value=1 %s> %s\n",
		$user{'sync'} ? "" : "checked", $text{'edit_dont'};
	}
printf "<input type=radio name=pass_def value=0 %s> $text{'edit_set'}\n",
	$in{'user'} ? "" : "checked";
print "<input type=password name=pass size=25></td> </tr>\n";

print "<tr> <td><b>$text{'edit_cert'}</b></td>\n";
printf "<td><input type=radio name=cert_def value=1 %s> %s\n",
	$user{'cert'} ? '' : 'checked', $text{'edit_none'};
printf "<input type=radio name=cert_def value=0 %s>\n",
	$user{'cert'} ? 'checked' : '';
print "<input name=cert size=50 value='$user{'cert'}'></td> </tr>\n";

print "<tr> <td><b>$text{'edit_lang'}</b></td> <td>\n";
printf "<input type=radio name=lang_def value=1 %s> %s\n",
	$user{'lang'} ? '' : 'checked', $text{'default'};
printf "<input type=radio name=lang_def value=0 %s>\n",
	$user{'lang'} ? 'checked' : '';
print "<select name=lang>\n";
foreach $l (&list_languages()) {
	printf "<option value=%s %s>%s (%s)\n",
		$l->{'lang'},
		$user{'lang'} eq $l->{'lang'} ? 'selected' : '',
		$l->{'desc'}, uc($l->{'lang'});
	}
print "</select></td> </tr>\n";

print "<tr> <td><b>$text{'edit_notabs'}</b></td> <td>\n";
printf "<input type=radio name=notabs value=1 %s> %s\n",
	$user{'notabs'} == 1 ? 'checked' : '', $text{'yes'};
printf "<input type=radio name=notabs value=2 %s> %s\n",
	$user{'notabs'} == 2 ? 'checked' : '', $text{'no'};
printf "<input type=radio name=notabs value=0 %s> %s</td> </tr>\n",
	$user{'notabs'} == 0 ? 'checked' : '', $text{'default'};

@mcan = $access{'mode'} == 1 ? @{$me->{'modules'}} :
	$access{'mode'} == 2 ? split(/\s+/, $access{'mods'}) :
			       &list_modules();
map { $mcan{$_}++ } @mcan;
map { $has{$_}++ } @{$user{'modules'}};

@mlist = grep { $access{'others'} || $has{$_} || $mcan{$_} } &list_modules();
print "<tr $cb> <td valign=top><b>$text{'edit_modules'}</b></td>\n";
print "<td><table width=100%>\n";
foreach $m (@mlist) {
	if (!$sw) { print "<tr>\n"; }
	print "<td>";
	if ($mcan{$m}) {
		printf "<input type=checkbox name=mod value=$m %s> %s\n",
			$has{$m} ? "checked" : "", (&module_info($m))[2];
		}
	else {
		printf "<img src=images/%s.gif> %s\n",
			$has{$m} ? 'tick' : 'empty', (&module_info($m))[2];
		}
	print "</td>";
	if ($sw) { print "<tr>\n"; }
	$sw = !$sw;
	}
print "</table></td> </tr>\n";
print "</table></td> </tr></table>\n";

print "<table width=100%> <tr>\n";
print "<td align=left width=33%><input type=submit value=\"$text{'save'}\"></td></form>\n";
if ($in{'user'}) {
	if ($access{'create'}) {
		print "<form action=edit_user.cgi>\n";
		print "<input type=hidden name=clone value=\"$in{'user'}\">\n";
		print "<td align=center width=33%>",
		      "<input type=submit value=\"$text{'edit_clone'}\">",
		      "</td></form>\n";
		}
	else { print "<td width=33%></td>\n"; }

	if ($access{'delete'}) {
		print "<form action=delete_user.cgi>\n";
		print "<input type=hidden name=user value=\"$in{'user'}\">\n";
		print "<td align=right width=33%>",
		      "<input type=submit value=\"$text{'delete'}\"></td></form>\n";
		}
	else { print "<td width=33%></td>\n"; }
	}
print "</tr> </table>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

