#ifndef _WAVE_FMT_H_
#define _WAVE_FMT_H_

#include <sys/types.h>

#define H_RIFF (*(int *)"RIFF")
#define H_WAVE (*(int *)"WAVE")
#define H_DATA (*(int *)"data")
#define H_FMT  (*(int *)"fmt ")

/* $B9=B$BNDj5A(B (ref. MS-Windows mmsystem.h) */
typedef struct tWAVEFORMAT
{
    u_int16_t wFormatTag;
    u_int16_t nChannels;
    u_int32_t nSamplesPerSec;
    u_int32_t nAvgBytesPerSec;
    u_int16_t nBlockAlign;
    u_int16_t wBitsPerSample;
} WAVEFORMAT, *PWAVEFORMAT;

typedef struct tWAVEFORMATEX
{
    u_int16_t wFormatTag;
    u_int16_t nChannels;
    u_int32_t nSamplesPerSec;
    u_int32_t nAvgBytesPerSec;
    u_int16_t nBlockAlign;
    u_int16_t wBitsPerSample;
    u_int16_t cbSize;
} WAVEFORMATEX, *PWAVEFORMATEX;

#endif /* _WAVE_FMT_H_ */
