/*
	This file is part of Warzone 2100.
	Copyright (C) 1999-2004  Eidos Interactive
	Copyright (C) 2005-2007  Warzone Resurrection Project

	Warzone 2100 is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Warzone 2100 is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Warzone 2100; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/
#ifndef _tex_
#define _tex_

#include "ivi.h"

//*************************************************************************



#define iV_TEX_MAX		64



//*************************************************************************

#define iV_TEXTEX(i)	((iTexture *) (&_TEX_PAGE[(i)].tex))
#define iV_TEXPAGE(i)	((iTexPage *) (&_TEX_PAGE[(i)]))
#define iV_TEXBMP(i)	((iBitmap *) (&_TEX_PAGE[(i)].tex.bmp))
#define iV_TEXWIDTH(i)	(_TEX_PAGE[(i)].tex.width)
#define iV_TEXHEIGHT(i) (_TEX_PAGE[(i)].tex.height)
#define iV_TEXNAME(i)	((char *) (&_TEX_PAGE[(i)].name))
#define iV_TEXTYPE(i)	(_TEX_PAGE[(i)].type)


//*************************************************************************

typedef struct
{
	iTexture	tex;
	uint8		type;
	char		name[80];
	unsigned int textPage3dfx;
	int		bResource;	// Was page provided by resource handler?
}
iTexPage;

//*************************************************************************
extern int _TEX_INDEX;
extern iTexPage	_TEX_PAGE[iV_TEX_MAX];

//*************************************************************************

int iV_GetTexture(char *filename);
extern int pie_ReloadTexPage(STRING *filename, char *pBuffer);
extern int pie_AddBMPtoTexPages(iSprite* s, STRING *filename, int type, iBool bColourKeyed, iBool bResource);
void pie_ChangeTexPage(int tex_index, iSprite* s, int type, iBool bColourKeyed, iBool bResource);
extern void pie_TexInit(void);

//*************************************************************************

extern void pie_TexShutDown(void);
BOOL FindTextureNumber(UDWORD TexNum,int* TexPage);

#endif
