
#ifndef _MYCTYPE_H
#define _MYCTYPE_H

#define MYCTYPE_SPACE 1
#define MYCTYPE_ALPHA 2
#define MYCTYPE_DIGIT 4
#define MYCTYPE_PRINT 8
#define MYCTYPE_CNTRL 16
#define MYCTYPE_HEX   32
#define MYCTYPE_INTSPACE 64
#define MYCTYPE_ASCII (MYCTYPE_CNTRL|MYCTYPE_PRINT)
#define MYCTYPE_ALNUM (MYCTYPE_ALPHA|MYCTYPE_DIGIT)
#define MYCTYPE_HEXNUM (MYCTYPE_HEX|MYCTYPE_DIGIT)
#define IS_SPACE(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_SPACE)
#define IS_ALPHA(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_ALPHA)
#define IS_DIGIT(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_DIGIT)
#define IS_PRINT(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_PRINT)
#define IS_CNTRL(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_CNTRL)
#define IS_ASCII(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_ASCII)
#define IS_ALNUM(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_ALNUM)
#define IS_HEXNUM(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_HEXNUM)
#define IS_INTSPACE(x) (MYCTYPE_MAP[(unsigned char)(x)] & MYCTYPE_INTSPACE)

extern unsigned char MYCTYPE_MAP[];

#endif
