
@NAME = ();
while(<DATA>) {
  chop;
  s/\s*$//;
  (($n, $m, $c) = split(" ", $_, 3)) >= 3 || next;
  push(@NAME, $n);
  $MAP{$n} = $m;
  $CODE{$n} = $c;
}

foreach $name (@NAME) {

$code = $CODE{$name};
$map = $MAP{$name};

print "$name\t$map\t$code\n";

@to_ucs = ();
%from_ucs = ();
open(MAP, "< $map");
open(OUT, "> ${name}_ucs.map");
while(<MAP>) {
  /^#/ && next;
  s/#.*//;
  (($i, $u) = split(" ")) || next;
  $i = hex($i);
  $u = hex($u);
  $to_ucs[$i] = $u;
  if ($u > 0) {
    $from_ucs{$u} = $i;
  }
}

# print OUT <<EOF;
# /*
#   These conversion tables between $code and
#   Unicode were made from
# 
#     ftp://ftp.unicode.org/Public/MAPPINGS/$map.
# */
print OUT <<EOF;
/* $code */

static wc_uint16 ${name}_ucs_map[ 0x5E * 0x9D ] = {
EOF

for $i (0xA1 .. 0xFE) {
for $j (0x40 .. 0x7E, 0xA1 .. 0xFE) {
  $_ = $i * 0x100 + $j;
  $u = $to_ucs[$_];
  if ($u) {
    printf OUT " 0x%.4X,", $u;
  } else {
    print OUT " 0,\t";
  }
  printf OUT "\t/* 0x%.4X */\n", $_;
}
}

@ucs = sort { $a <=> $b } keys %from_ucs;
$nucs = @ucs + 0;

print OUT <<EOF;
};

#define N_ucs_${name}_map $nucs
/*
    UCS-2   Big5
*/
static wc_map ucs_${name}_map[ N_ucs_${name}_map ] = {
EOF
for(@ucs) {
  $x = $from_ucs{$_};
#  $u = ($x >> 8) & 0xFF;
#  $l = $x & 0x00FF;
#  $n = (($u - 0xA1) * 0x9D) + $l - (($l < 0xA1) ? 0x40 : 0x62);
#  if ($n < 0x2800) {
#    $x = ((int($n / 0x5E) + 0x21) << 8) | (($n % 0x5E) + 0x21);
#  } else {
#    $n -= 0x2800;
#    $x = ((int($n / 0x5E) + 0x21) << 8) | (($n % 0x5E) + 0x21);
#    $x |= 0x8000;
#  }
  printf OUT "  { 0x%.4X, 0x%.4X },\n", $_, $x;
}

print OUT <<EOF;
};
EOF

close(MAP);
}

__END__
big5		EASTASIA/OTHER/BIG5.TXT		Big5 (Chinese Taiwan)
