#!/usr/local/bin/perl5

# perl5 mk_big5map.pl < cjk.inf > big5_cns.map

$n = 0;
while(<>) {
  if (/^Big Five Level (\d+) .* Plane (\d+)/) {
    $bl = $1;
    $cp = $2;
    $n = 1;
    next;
  }
  if (/^I adapted the above/) {
    last;
  }
  $n || next;

  chop;
  if (/0xCAF8-0xD6CB <-> 0x2439-0x376E/) {
    $_ = "0xCAF8-0xD779 <-> 0x2439-0x387D";
  } elsif (/0xD6CC <-> 0x3E63/) {
    next;
  } elsif (/0xD6CD-0xD779 <-> 0x3770-0x387D/) {
    next;
  } elsif (/0xD77A <-> 0x3F6A/) {
    $_ = "0xD77A <-> 0x3F6A";
  } elsif (/0xD77B-0xDADE <-> 0x387E-0x3E62/) {
    $_ = "0xD77B-0xDBA6 <-> 0x387E-0x3F69";
  } elsif (/0xDADF <-> 0x376F/) {
    next;
  }
  s/#.*$//;
  s/\s//g;
  if (s/^(.*)<->//) {
    $b = $1;
    $c = $_;
    $both = 1;
  } elsif (s/^(.*)->//) {
    $b = $1;
    $c = $_;
    $both = 0;
  } else {
    next;
  }
  ($b1, $b2) = split(/-/, $b);
  if ($b2) {
    $be = $b2;
  } else {
    $be = $b1;
  }
  if ($be =~ /7E$/) {
    $be = sprintf("0x%.4X", hex($be) + 0x23);
  } elsif ($be =~ /FE$/) {
    $be = sprintf("0x%.4X", hex($be) + 0x42);
  } else {
    $be = sprintf("0x%.4X", hex($be) + 1);
  }
  if ($c =~ /,/) {
    ($c1, $c2) = split(/,/, $c);
    $C->{$b1} = &CNS($c1, $cp);
    $C->{$b2} = &CNS($c2, $cp);
    $B->[$cp]{$c1} = $b1;
    $B->[$cp]{$c2} = $b2;
    if ($both) {
    for $c ($c1, $c2) {
      if ($c =~ /7E$/) {
        $ce = sprintf("0x%.4X", hex($c) + 0xa3);
      } else {
        $ce = sprintf("0x%.4X", hex($c) + 1);
      }
      if ($both && !defined($B->[$cp]{$ce})) {
        $B->[$cp]{$ce} = "0x0000";
      }
    }
    }
    $both = 0;
  } elsif ($c =~ /\*/) {
    $C->{$b1} = 0;
    $both = 0;
  } elsif ($c =~ /-/) {
    ($c1, $c2) = split(/-/, $c);
    if ($c2 =~ /7E$/) {
      $ce = sprintf("0x%.4X", hex($c2) + 0xa3);
    } else {
      $ce = sprintf("0x%.4X", hex($c2) + 1);
    }
    $C->{$b1} = &CNS($c1, $cp);
    if ($both) {
      $B->[$cp]{$c1} = $b1;
    }
  } else {
    $C->{$b} = &CNS($c, $cp);
    if ($both) {
      $B->[$cp]{$c} = $b;
    }
    if ($c =~ /7E$/) {
      $ce = sprintf("0x%.4X", hex($c) + 0xa3);
    } else {
      $ce = sprintf("0x%.4X", hex($c) + 1);
    }
  }
  if (!defined($C->{$be})) {
    $C->{$be} = 0;
  }
  if ($both && !defined($B->[$cp]{$ce})) {
    $B->[$cp]{$ce} = "0x0000";
  }
}

#print <<EOF;
#/*
#  These conversion tables between Big5 and CNS 11643 were made from
#  CJK.INF Version 2.1 (July 12, 1996) written by Ken Lunde.
#
#    ftp://ftp.ora.com/pub/examples/nutshell/ujip/doc/cjk.inf
#*/
print <<EOF;
/* Big5 <-> CNS 11643 */
EOF

&print_big5_cns($C);

foreach(1..4) {
  &print_cns_big5($_, $B->[$_]);
}

sub print_big5_cns {
  local($C) = @_;
  local($n, @a);

  @a = sort keys %{$C};
  $n = @a + 0;
  print <<EOF;

#define N_big5_cns11643_map $n
/*
    Big5    CNS 11643-1
    Big5    CNS 11643-2 | 0x8000
    Big5    CNS 11643-3 | 0x0080
    Big5    CNS 11643-4 | 0x8080
*/
static wc_map big5_cns11643_map[ N_big5_cns11643_map ] = {
EOF
  foreach(@a) {
    printf "  { $_, 0x%.4X },", $C->{$_};
    if ($C->{$_} & 0x8000) {
      if ($C->{$_} & 0x80) {
        print "\t/* CNS 11643-4 */\n";
      } else {
        print "\t/* CNS 11643-2 */\n";
      }
    } else {
      if ($C->{$_} & 0x80) {
        print "\t/* CNS 11643-3 */\n";
      } elsif ($C->{$_}) {
        print "\t/* CNS 11643-1 */\n";
      } else {
        print "\n";
      }
    }
  }
  print <<EOF;
};
EOF
}

sub print_cns_big5 {
  local($cp, $B) = @_;
  local($n, @a);

  @a = sort keys %{$B};
  $n = @a + 0;
  print <<EOF;

#define N_cns11643${cp}_big5_map $n

static wc_map cns11643${cp}_big5_map[ N_cns11643${cp}_big5_map ] = {
EOF
  foreach(@a) {
    print "  { $_, $B->{$_} },\n";
  }
  print <<EOF;
};
EOF
}

sub CNS {
  local($c, $p) = @_;

  if ($p == 1) {
    return hex($c);
  } elsif ($p == 2) {
    return hex($c) + 0x8000;
  } elsif ($p == 3) {
    return hex($c) + 0x0080;
  } elsif ($p == 4) {
    return hex($c) + 0x8080;
  }
}
