/*
 * Configuration for w3m
 */

#ifndef _CONFIGURED_
#define _CONFIGURED_

/* User Configuration */

/* 
   If you define DICT, you can use dictionary look-up function
   in w3m. See README.dict for detail.
*/
#undef DICT

/*
   If you define USE_MARK, you can use set-mark (C-SPC),
   goto-next-mark (ESC p), goto-next-mark (ESC n) and
   mark-by-regexp (").
*/
#undef USE_MARK

/*
   If you want to load and save URL history.
 */
#define USE_HISTORY

/*
   BG_COLOR enables w3m to set background color.
 */
#define BG_COLOR

/*
   VIEW_UNSEENOBJECTS enables w3m to make a link to unseen objects.
   e.g. background image.
 */
#undef VIEW_UNSEENOBJECTS

/*
   VI_PREC_NUM enables vi-like behavior for '2 SPC' or '2 b'
 */
#undef VI_PREC_NUM

/*
 * Do word fill
 */
#undef FORMAT_NICE

/*
 * Support Gopher protocol
 */
#undef USE_GOPHER

/*
 * Support NNTP
 */
#define USE_NNTP

/*
 * Support ANSI color escape sequences
 */
#define ANSI_COLOR

/*
 * Enable id attribute
 */
#define ID_EXT

/*
 * Save Current-buffer Information
 */
#define BUFINFO

/*
 * Support EGD (Entropy Gathering Daemon)
 */
#undef USE_EGD

/*
 * MENU_MAP enables w3m to show image map link with popup menu.
 */
#define MENU_MAP

/*
 * Use Emacs-like key binding for file name completion
 */
#undef EMACS_LIKE_LINEEDIT

/*
 * Remove line trailing spaces in html buffer.
 */
#undef ENABLE_REMOVE_TRAILINGSPACES

/**********************************************************/
#ifdef makefile_parameter

SUFFIX=-m17n
BIN_DIR = /usr/local/bin
HELP_DIR = /usr/local/lib/w3m-m17n
LIB_DIR = /use/local/lib/w3m-m17n
HELP_FILE = w3mhelp-w3m_ja.html
SYS_LIBRARIES =   -ltermcap  -L/usr/local/lib -lssl -lcrypto 
LOCAL_LIBRARIES = 
CC = gcc
MYCFLAGS = -O -I./gc/include  -I/usr/local/include/openssl -I/usr/local/include -I./libwc
GCCFLAGS = -O -I./gc/include -DATOMIC_UNCOLLECTABLE -DNO_EXECUTE_PERMISSION -DALL_INTERIOR_POINTERS -DSILENT -DNO_DEBUGGING #-DNO_SIGNALS
KEYBIND_SRC = keybind.c
KEYBIND_OBJ = keybind.o
EXT=
MATHLIB=-lm
GCLIB=gc/gc.a
GCTARGET=gc/gc.a
WCLIB=-L./libwc -lwc
WCTARGET=wctarget
WCCFLAGS=-DUSE_UNICODE
RANLIB=ranlib
MKDIR=mkdir -p
VERSION=0.2.1-m17n-0.19
MODEL=FreeBSD.i386-monster-ja
PERL=/usr/bin/perl
CYGWIN=0
RC_DIR = ~/.w3m-m17n/
#else


#define USE_M17N
#define USE_UNICODE
#define DISPLAY_CHARSET WC_CES_EUC_JP
#define DOCUMENT_CHARSET WC_CES_EUC_JP
#define SYSTEM_CHARSET WC_CES_EUC_JP

#define JA 0
#define EN 1
#define LANG JA
#define COLOR
#define MOUSE

#define USE_SYSMOUSE
#define MENU
#define USE_COOKIE
#define USE_SSL
#define USE_SSL_VERIFY
#undef FTPPASS_HOSTNAMEGEN
#define SHOW_PARAMS

#define DEF_EDITOR "/usr/bin/vi"
#define DEF_MAILER "/usr/bin/mail"
#define DEF_EXT_BROWSER "/usr/local/bin/netscape"

#define LIB_DIR      "/home/h-saka/lib/w3m-m17n"
#define HELP_DIR     "/home/h-saka/lib/w3m-m17n"
#define HELP_FILE    "w3mhelp.html"
#define W3MCONFIG    "w3mconfig"

#define RC_DIR       "~/.w3m-m17n/"
#define BOOKMARK     "bookmark.html"
#define CONFIG_FILE  "config"
#define KEYMAP_FILE  "keymap"
#define MENU_FILE    "menu"
#define COOKIE_FILE  "cookie"
#define HISTORY_FILE "history"

#define USER_MAILCAP RC_DIR "/mailcap"
#define SYS_MAILCAP  "/etc/mailcap"
#define USER_MIMETYPES "~/.mime.types"
#define SYS_MIMETYPES "/usr/local/lib/mime.types"

#define DEF_SAVE_FILE "index.html"

#define TERMIOS
#define DIRENT
#define STRCASECMP
#define STRCHR
#define STRERROR
#define SYS_ERRLIST
#undef NOBCOPY
#define HAVE_WAITPID
#define HAVE_WAIT3
#define HAVE_STRFTIME

#define GETCWD
#define GETWD
#define READLINK
#define HAVE_SETENV
#define HAVE_PUTENV
#define READLINK


#define SETJMP(env) sigsetjmp(env,1)
#define LONGJMP(env,val) siglongjmp(env,val)
#define JMP_BUF sigjmp_buf

typedef void MySignalHandler;
#define SIGNAL_ARG int _dummy
#define SIGNAL_ARGLIST 0
#define SIGNAL_RETURN return
/*
   If you want to use IPv6, define this symbol.
 */
#undef INET6

#undef TABLE_EXPAND
#undef TABLE_NO_COMPACT
#define NOWRAP 1
#define NEW_FORM 1
#define MATRIX 1
#undef NO_FLOAT_H

#endif /* makefile_parameter */
#endif /* _CONFIGURED_ */

