/* $Id: textlist.c,v 1.1.1.1 2000/01/04 05:46:50 aito Exp $ */
#include "textlist.h"
#include "indep.h"
#include "Str.h"
#include "gc.h"

TextListItem*
newTextListItem(char *s,TextListItem *n,TextListItem *p)
{
  TextListItem *it;
  it = New(TextListItem);
  it->ptr = allocStr(s,0);
  it->next = n;
  it->prev = p;
  return it;
}

TextList*
newTextList()
{
  TextList *tl = New(TextList);
  tl->first = tl->last = NULL;
  tl->nitem = 0;
  return tl;
}

void
pushText(TextList *tl, char *s)
{
  TextListItem *it = newTextListItem(s,NULL,tl->last);
  if (tl->first == NULL) {
    tl->first = it;
    tl->last = it;
    tl->nitem = 1;
  }
  else {
    tl->last->next = it;
    tl->last = it;
    tl->nitem++;
  }
}

void
appendText(TextList *tl, char *s)
{
  TextListItem *it;
  Str tmp;

  if (tl->last == NULL) {
    it = newTextListItem(s,NULL,tl->last);
    tl->first = it;
    tl->last = it;
    tl->nitem = 1;
  }
  else {
    tmp = Strnew_size(strlen(tl->last->ptr)+strlen(s));
    Strcat_charp(tmp,tl->last->ptr);
    Strcat_charp(tmp,s);
    tl->last->ptr = tmp->ptr;
  }
}

char *
popText(TextList *tl)
{
  TextListItem *f;

  if (tl == NULL || tl->first == NULL)
    return NULL;
  f = tl->first;
  tl->first = f->next;
  if (tl->first)
    tl->first->prev = NULL;
  tl->nitem--;
  return f->ptr;
}

TextList *
appendTextList(TextList *tl, TextList *tl2)
{
    if (tl && tl2) {
	if (tl2->first) {
	    if (tl->last) {
		tl->last->next = tl2->first;
		tl2->first->prev = tl->last;
		tl->last = tl2->last;
		tl->nitem += tl2->nitem;
	    } else {
		tl->first = tl2->first;
		tl->last = tl2->last;
		tl->nitem = tl2->nitem;
	    }
	}
	tl2->first = tl2->last = NULL;
	tl2->nitem = 0;
    }

    return tl;
}
