/*
 * client-side image maps
 */
#include "fm.h"

char *map1 = "<HTML><HEAD><TITLE>Image map links</TITLE></HEAD>\
<BODY><H1>Image map links</H1>";

Buffer *
follow_map_panel(Buffer *buf, struct parsed_tagarg *arg)
{
  Str mappage;
  MapList *ml;
  char *name, *q;
  TextListItem *t;
  
  name = tag_get_value(arg,"link");
  if (name == NULL) return NULL;

  for (ml = buf->maplist; ml != NULL; ml = ml->next) {
    if (!Strcmp_charp(ml->name,name)) break;
  }
  if (ml == NULL) return NULL;

  mappage = Strnew_charp(map1);
  for (t = ml->urls->first; t != NULL; t = t->next) {
    q = htmlquote_str(t->ptr);
    Strcat_charp(mappage,"<a href=\"");
    Strcat_charp(mappage,q);
    Strcat_charp(mappage,"\">");
    Strcat_charp(mappage,q);
    Strcat_charp(mappage,"</a><br>\n");
  }
  Strcat_charp(mappage,"</body></html>");

  return loadHTMLString(mappage->ptr);
}

/* append frame URL */
static void
append_frame_info(Str html, struct frameset *set, int level)
{
  char *q;
  int i,j;

  if (!set) return;
  for (i = 0; i < set->col * set->row; i++) {
    for (j = 0; j < level; j++)
      Strcat_charp(html,"   ");
    if (set->set_attr[i] == F_BODY) {
      q = htmlquote_str(set->set[i].body->url);
      Strcat_charp(html,"<a href=\"");
      Strcat_charp(html,q);
      Strcat_charp(html,"\">");
      Strcat_charp(html,set->set[i].body->name);
      Strcat_charp(html," ");
      Strcat_charp(html,q);
      Strcat_charp(html,"</a>\n");
    }
    else {
      append_frame_info(html,set->set[i].frame,level+1);
    }
  }
}

static char*
code_str(char code)
{
  switch (code) {
  case '\0': return "US_ASCII";
  case 'E':  return "EUC_JP";
  case 'S':  return "SHIFT_JIS";
  case 'j':  return "ISO-2022-JP (JIS X0208-1978 + JIS X0201-1976)";
  case 'N':  return "ISO-2022-JP (JIS X0208-1983 + JIS X0201-1976)";
  case 'm':  return "ISO-2022-JP (JIS X0208-1978 + US_ASCII)";
  case 'n':  return "ISO-2022-JP (JIS X0208-1983 + US_ASCII)";
  default: return "unknown";
  }
}
  
/*
 * information of current page and link 
 */
Buffer *
page_info_panel(Buffer *buf)
{
  Str tmp = Strnew_size(1024);
  Anchor *a;
  TextListItem *ti;
  struct frameset *f_set = NULL;
  int all;

  Strcat_charp(tmp,"<html><head><title>Information about current page</title></head><body>");
  Strcat_charp(tmp,"<h1>Information about current page</h1><table>");
  if (buf == NULL)
    goto end;
  Strcat_charp(tmp,"<tr><td>Title<td>");
  Strcat_charp(tmp,htmlquote_str(cleanup_str(buf->buffername)));
  Strcat_charp(tmp,"<tr><td>Current URL<td>");
  Strcat_charp(tmp,htmlquote_str(parsedURL2Str(&buf->currentURL)->ptr));
  Strcat_charp(tmp,"<tr><td>Document Type<td>");
  Strcat_charp(tmp,buf->type);
  Strcat_charp(tmp,"<tr><td>Last Modified<td>");
  Strcat_charp(tmp,last_modified(buf));
#ifdef JP_CHARSET
  Strcat_charp(tmp,"<tr><td>Document Code<td>");
  Strcat_charp(tmp,code_str(buf->document_code));
#endif
  Strcat_charp(tmp,"<tr><td>Number of line<td>");
  all = buf->allLine;
  if (all == 0 && buf->lastLine)
    all = buf->lastLine->linenumber;
  Strcat(tmp,Sprintf("%d",all));
  Strcat_charp(tmp,"<tr><td>Transferred byte<td>");
  Strcat(tmp,Sprintf("%d",buf->trbyte));

  a = retrieveCurrentAnchor(buf);
  if (a != NULL) {
    Strcat_charp(tmp,"<tr><td>URL of current anchor<td>");
    Strcat_charp(tmp,htmlquote_str(a->url));
  }
  Strcat_charp(tmp,"</table>\n");
  if (buf->document_header != NULL) {
    Strcat_charp(tmp,"<hr width=50%>\n");
    Strcat_charp(tmp,"<h1>Header information</h1>\n");
    for (ti = buf->document_header->first; ti != NULL; ti = ti->next) {
      Strcat_charp(tmp,htmlquote_str(ti->ptr));
      Strcat_charp(tmp,"<br>");
    }
  }
  if (buf->frameset != NULL)
    f_set = buf->frameset;
  else if (buf->bufferprop & BP_FRAME && buf->nextBuffer != NULL)
    f_set = buf->nextBuffer->frameset;

  if (f_set) {
    Strcat_charp(tmp,"<hr width=50%><h1>Frame information</h1><pre>");
    append_frame_info(tmp,f_set,0);
    Strcat_charp(tmp,"</pre>");
  }
end:
  Strcat_charp(tmp,"</body></html>");
  return loadHTMLString(tmp->ptr);
}
  
