/* $Id: html.h,v 1.2 2000/01/11 10:18:23 aito Exp $ */
#ifndef _HTML_H
#define _HTML_H
#ifdef USE_SSL
#include <ssl.h>
#endif

struct cmdtable {
  char           *cmdname;
  int             cmd;
};

struct mailcap {
  char           *type;
  char           *viewer;
};

struct table2 {
  char           *item1;
  char           *item2;
};

typedef struct {
  char  *referer;
  int    flag;
} URLOption; 

typedef struct _ParsedURL {
  int             scheme;
  char           *user;
  char           *pass;
  char           *host;
  int             port;
  char           *file;
  char           *label;
  int             is_nocache;
}               ParsedURL;

#ifdef USE_SSL
#define SSL_BUF_SIZE	1536
struct ssl_stream {
  char              *buf;
  int                bufsize;
  int                pos, epos;
  SSL               *handle;
  int                sock;
  int                status;
};
typedef struct ssl_stream *SSLStream;
#endif

typedef union {
  FILE           *f;
  char           *is;
#ifdef USE_SSL
  SSLStream      ss;
#endif
} Stream;

typedef struct {
  unsigned char   scheme;
  char            iseof;
  char            is_cgi;
  char            encoding;
  Stream          stream;
  char            stream_type;
  void           (*close)();
  char           *ext;
  int             gzip;
}               URLFile;

#define SMT_FILE         0
#define SMT_STRING       1
#ifdef USE_SSL
#define SMT_SSL          2
#endif

#define ENC_7BIT	0
#define ENC_BASE64	1
#define ENC_QUOTE	2

#define HTML_UNKNOWN	0
#define HTML_A		1
#define HTML_N_A	2
#define HTML_H		3
#define HTML_N_H	4
#define HTML_P		5
#define HTML_BR		6
#define HTML_B		7
#define HTML_N_B	8
#define HTML_UL		9
#define HTML_N_UL	10
#define HTML_LI		11
#define HTML_OL		12
#define HTML_N_OL	13
#define HTML_TITLE	14
#define HTML_N_TITLE	15
#define HTML_HR		16
#define HTML_DL		17
#define HTML_N_DL	18
#define HTML_DT		19
#define HTML_DD		20
#define HTML_PRE	21
#define HTML_N_PRE	22
#define HTML_BLQ	23
#define HTML_N_BLQ	24
#define HTML_IMG	25
#define HTML_LISTING	26
#define HTML_N_LISTING	27
#define HTML_XMP	28
#define HTML_N_XMP	29
#define HTML_PLAINTEXT	30
#define HTML_TABLE      31
#define HTML_N_TABLE    32
#define HTML_META       33
#define HTML_N_P        34
#define HTML_FRAME      35
#define HTML_FRAMESET   36
#define HTML_N_FRAMESET 37
#define HTML_CENTER     38
#define HTML_N_CENTER   39
#define HTML_FONT       40
#define HTML_N_FONT     41
#define HTML_FORM       42
#define HTML_N_FORM     43
#define HTML_INPUT      44
#define HTML_TEXTAREA   45
#define HTML_N_TEXTAREA 46
#define HTML_SELECT     47
#define HTML_N_SELECT   48
#define HTML_OPTION     49
#define HTML_NOBR       50
#define HTML_N_NOBR     51
#define HTML_DIV        52
#define HTML_N_DIV      53
#define HTML_ISINDEX    54
#define HTML_MAP        55
#define HTML_N_MAP      56
#define HTML_AREA       57
#define HTML_SCRIPT     58
#define HTML_N_SCRIPT   59
#define HTML_BASE       60
#define HTML_DEL        61
#define HTML_N_DEL      62
#define HTML_INS        63
#define HTML_N_INS      64
#define HTML_U          65
#define HTML_N_U        66
#define HTML_STYLE      67
#define HTML_N_STYLE    68
#define HTML_WBR        69
#define HTML_EM		70
#define HTML_N_EM	71
#define HTML_BODY	72
#define HTML_N_BODY	73
#define HTML_TR         74
#define HTML_N_TR       75
#define HTML_TD         76
#define HTML_N_TD       77
#define HTML_CAPTION    78
#define HTML_N_CAPTION  79
#define HTML_TH         80
#define HTML_N_TH       81
#define HTML_THEAD      82
#define HTML_N_THEAD    83
#define HTML_TBODY      84
#define HTML_N_TBODY    85
#define HTML_TFOOT      86
#define HTML_N_TFOOT    87
#define HTML_COLGROUP   88
#define HTML_N_COLGROUP 89
#define HTML_COL        90

   /* pseudo tag */
#define HTML_DUMMY_TABLE    113
#define HTML_RULE           114
#define HTML_N_RULE         115
#define HTML_PRE_INT        116
#define HTML_N_PRE_INT      117
#define HTML_TITLE_ALT      118
#define HTML_FORM_INT       119
#define HTML_N_FORM_INT     120
#define HTML_DL_COMPACT     121
#define HTML_INPUT_ALT      122
#define HTML_N_INPUT_ALT    123
#define HTML_IMG_ALT        124
#define HTML_N_IMG_ALT      125
#define HTML_EOL            126
#define HTML_NOP	    127

struct environment {
  char            env;
  int             type;
  int             count;
  char            indent;
};

#define MAX_ENV_LEVEL    20
#define MAX_INDENT_LEVEL 10

#define INDENT_INCR 4

#define SCM_UNKNOWN	255
#define SCM_MISSING	254
#define SCM_HTTP	0
#define SCM_GOPHER	1
#define SCM_FTP		2
#define SCM_FTPDIR	3
#define SCM_LOCAL	4
#define SCM_NNTP	5
#define SCM_NEWS	6
#define SCM_MAILTO      7
#ifdef USE_SSL
#define SCM_HTTPS       8
#endif

#endif
