#include "fm.h"

#ifdef USE_GPM
#include <gpm.h>
extern int do_getch();
#define getch()	do_getch()
#endif
char           *NullLine = "";
Lineprop        NullProp[] = {0};

/*
 * Buffer creation
 */
Buffer         *
newBuffer(int width)
{
  Buffer         *n;

  n = New(Buffer);
  if (n == NULL)
    return NULL;
  bzero((void*)n, sizeof(Buffer));
  n->width = width;
  n->currentURL.scheme = SCM_UNKNOWN;
  n->baseURL = NULL;
  n->baseTarget = NULL;
  n->buffername = "";
  n->bufferprop = BP_NORMAL;
  n->clone = New(int);
  *n->clone = 1;
  n->trbyte = 0;
  return n;
}

/*
 * Create null buffer
 */
Buffer         *
nullBuffer(void)
{
  Buffer         *b;

  b = newBuffer(COLS);
  b->buffername = "*Null*";
  return b;
}

/*
 * clearBuffer: clear buffer content
 */
void
clearBuffer(Buffer * buf)
{
  buf->firstLine = buf->topLine = buf->currentLine = buf->lastLine = NULL;
  buf->allLine = 0;
  GC_gcollect();
}

/*
 * discardBuffer: free buffer structure
 */

void
discardBuffer(Buffer * buf)
{
  int i;
  Buffer *b;

  clearBuffer(buf);
  for(i = 0; i < MAX_LB; i++) {
    b = buf->linkBuffer[i];
    if (b == NULL)
      continue;
    b->linkBuffer[REV_LB[i]] = NULL;
  }
  if (--(*buf->clone))
    return;
  if (buf->pagerSource) {
    if (buf->bufferprop & BP_PIPE)
      pclose(buf->pagerSource);
    else
      fclose(buf->pagerSource);
  }
  if (buf->sourcefile) {
    if (buf->real_scheme != SCM_LOCAL || buf->bufferprop & BP_FRAME)
      unlink(buf->sourcefile);
  }
  if (buf->frameset)
    deleteFrameSet(buf->frameset);
}

/*
 * namedBuffer: Select buffer which have specified name
 */
Buffer         *
namedBuffer(Buffer * first, char *name)
{
  Buffer         *buf;

  if (!strcmp(first->buffername, name)) {
    return first;
  }
  for (buf = first; buf->nextBuffer != NULL; buf = buf->nextBuffer) {
    if (!strcmp(buf->nextBuffer->buffername, name)) {
      return buf->nextBuffer;
    }
  }
  return NULL;
}

/*
 * deleteBuffer: delete buffer
 */
Buffer         *
deleteBuffer(Buffer * first, Buffer * delbuf)
{
  Buffer         *buf, *b;

  if (first == delbuf && first->nextBuffer != NULL) {
    buf = first->nextBuffer;
    discardBuffer(first);
    return buf;
  }
  if ((buf = prevBuffer(first, delbuf)) != NULL) {
    b = buf->nextBuffer;
    buf->nextBuffer = b->nextBuffer;
    discardBuffer(b);
  }
  return first;
}

/*
 * replaceBuffer: replace buffer
 */
Buffer         *
replaceBuffer(Buffer * first, Buffer * delbuf, Buffer *newbuf)
{
  Buffer         *buf;

  if (delbuf == NULL) {
    newbuf->nextBuffer = first;
    return newbuf;
  }
  if (first == delbuf) {
    newbuf->nextBuffer = delbuf->nextBuffer;
    discardBuffer(delbuf);
    return newbuf;
  }
  if (delbuf && (buf = prevBuffer(first, delbuf))) {
    buf->nextBuffer = newbuf;
    newbuf->nextBuffer = delbuf->nextBuffer;
    discardBuffer(delbuf);
    return first;
  }
  newbuf->nextBuffer = first;
  return newbuf;
}

static Buffer  *
nthBuffer(Buffer * firstbuf, int n)
{
  int             i;
  Buffer         *buf = firstbuf;

  if (n < 0)
    return firstbuf;
  for (i = 0; i < n; i++) {
    if (buf == NULL)
      return NULL;
    buf = buf->nextBuffer;
  }
  return buf;
}

static void
writeBufferName(Buffer * buf, int n)
{
  Str     msg;
  int     all;

  all = buf->allLine;
  if (all == 0 && buf->lastLine != NULL)
    all = buf->lastLine->linenumber;
  move(n, 0);
  msg = Sprintf("<%s> [%d lines]", cleanup_str(buf->buffername), all);
  if (buf->filename != NULL) {
    switch(buf->currentURL.scheme) {
    case SCM_LOCAL:
      if (strcmp(buf->currentURL.file, "-")) {
	Strcat_char(msg, ' ');
	Strcat_charp(msg, buf->filename);
      }
      break;
    case SCM_UNKNOWN:
    case SCM_MISSING:
      break;
    default:
      Strcat_char(msg, ' ');
      Strcat(msg, parsedURL2Str(&buf->currentURL));
      break;
    }
  }
  addnstr_sup(msg->ptr, COLS - 1);
}


/*
 * gotoLine: go to line number
 */
void
gotoLine(Buffer * buf, int n)
{
  char            msg[32];
  Line           *l = buf->firstLine;

  if (l == NULL)
    return;
  if (l->linenumber > n) {
    sprintf(msg, "First line is #%ld", l->linenumber);
    disp_message(msg, NIL);
    buf->topLine = buf->currentLine = l;
    return;
  }
  if (buf->lastLine->linenumber < n) {
    l = buf->lastLine;
    sprintf(msg, "Last line is #%ld", l->linenumber);
    disp_message(msg, NIL);
    buf->topLine = buf->currentLine = l;
    return;
  }
  for (; l != NULL; l = l->next) {
    if (l->linenumber == n) {
      buf->currentLine = l;
      if (n < buf->topLine->linenumber ||
	  buf->topLine->linenumber+LASTLINE+1 <= n)
	  buf->topLine = lineSkip(l, -(LASTLINE+1) / 2);
      break;
    }
  }
}


static Buffer  *
listBuffer(Buffer * top, Buffer * current)
{
  int             i, c;
  Buffer         *buf = top;

  move(0,0);
#ifdef COLOR
  if (useColor) {
    setfcolor(basic_color);
#ifdef BG_COLOR
    setbcolor(bg_color);
#endif
  }
#endif
  clrtobotx();
  for (i = 0; i < LASTLINE; i++) {
    if (buf == current) {
      c = i;
      standout();
    }
    writeBufferName(buf, i);
    if (buf == current) {
      standend();
      clrtoeolx();
      move(i,0);
      toggle_stand();
    }
    else
      clrtoeolx();
    if (buf->nextBuffer == NULL) {
      move(i+1,0);
      clrtobotx();
      break;
    }
    buf = buf->nextBuffer;
  }
  standout();
  message("Buffer selection mode: SPC for select / D for delete buffer", 0, 0);
  standend();
/*
  move(LASTLINE, COLS - 1);
*/
  move(c, 0);
  refresh();
  return buf->nextBuffer;
}


/*
 * Select buffer visually
 */
Buffer         *
selectBuffer(Buffer * firstbuf, Buffer * currentbuf, char *selectchar)
{
  int             i, cpoint,	/* Current Buffer Number */
                  spoint,	/* Current Line on Screen */
                  maxbuf, sclimit = LASTLINE;	/* Upper limit of line number
						 * in the screen */
  Buffer         *buf, *topbuf;
  char            c;

  i = cpoint = 0;
  for (buf = firstbuf; buf != NULL; buf = buf->nextBuffer) {
    if (buf == currentbuf)
      cpoint = i;
    i++;
  }
  maxbuf = i;

  if (cpoint >= sclimit) {
    spoint = sclimit / 2;
    topbuf = nthBuffer(firstbuf, cpoint - spoint);
  } else {
    topbuf = firstbuf;
    spoint = cpoint;
  }
  listBuffer(topbuf, currentbuf);

  for (;;) {
    if ((c = getch()) == ESC_CODE) {
      if ((c = getch()) == '[' || c == 'O') {
	switch (c = getch()) {
	case 'A':
	  c = 'k';
	  break;
	case 'B':
	  c = 'j';
	  break;
	case 'C':
	  c = ' ';
	  break;
	case 'D':
	  c = 'B';
	  break;
        }
      }
    }
    switch (c) {
    case CTRL_N:
    case 'j':
      if (spoint < sclimit - 1) {
	if (currentbuf->nextBuffer == NULL)
	  continue;
	writeBufferName(currentbuf, spoint);
	currentbuf = currentbuf->nextBuffer;
	cpoint++;
	spoint++;
	standout();
	writeBufferName(currentbuf, spoint);
	standend();
	move(spoint,0);
	toggle_stand();
      } else if (cpoint < maxbuf - 1) {
	topbuf = currentbuf;
	currentbuf = currentbuf->nextBuffer;
	cpoint++;
	spoint = 1;
	listBuffer(topbuf, currentbuf);
      }
      break;
    case CTRL_P:
    case 'k':
      if (spoint > 0) {
	writeBufferName(currentbuf, spoint);
	currentbuf = nthBuffer(topbuf, --spoint);
	cpoint--;
	standout();
	writeBufferName(currentbuf, spoint);
	standend();
	move(spoint,0);
	toggle_stand();
      } else if (cpoint > 0) {
	i = cpoint - sclimit;
	if (i < 0)
	  i = 0;
	cpoint--;
	spoint = cpoint - i;
	currentbuf = nthBuffer(firstbuf, cpoint);
	topbuf = nthBuffer(firstbuf, i);
	listBuffer(topbuf, currentbuf);
      }
      break;
    default:
      *selectchar = c;
      return currentbuf;
    }
/*
    move(LASTLINE, COLS - 1);
*/
    move(spoint, 0);
    refresh();
  }
}


/*
 * Reshape HTML buffer
 */
void
reshapeBuffer(Buffer * buf)
{
  URLFile         f;

  if ((f.stream.f = fopen(buf->sourcefile, "r")) == NULL)
    return;
  f.stream_type = SMT_FILE;
  f.iseof = 0;
  f.encoding = 0;
  f.scheme = SCM_LOCAL;
  f.close = (void(*)())fclose;

  clearBuffer(buf);
  deleteFrameSet(buf->frameset);

  loadHTMLstream(&f, buf, NULL);

  buf->topLine = buf->firstLine;
  buf->lastLine = buf->currentLine;
  buf->currentLine = buf->firstLine;
  buf->width = COLS-5;
  buf->height = LASTLINE+1;

  f.close(f.stream);
}

/* shallow copy */
void
copyBuffer(Buffer *a, Buffer *b)
{
  bcopy((void*)b,(void*)a,sizeof(Buffer));
}

Buffer *
prevBuffer(Buffer *first, Buffer *buf)
{
  Buffer         *b;

  for (b = first; b != NULL && b->nextBuffer != buf; b = b->nextBuffer);
  return b;
}


