
/* $Id: etc.c,v 1.21 2000/06/06 05:39:13 aito Exp $ */
#include "fm.h"
#include <pwd.h>
#include "myctype.h"
#include "html.h"
#include "local.h"
#include "hash.h"

#ifdef GETCWD
#include <unistd.h>
#include <sys/param.h>
#endif				/* GETCWD */

#ifdef __EMX__
#include <process.h>
#endif				/* __EMX__ */

#include <sys/types.h>
#include <time.h>
#include <sys/wait.h>
#include <signal.h>

#ifdef	__WATT32__
#define	read(a,b,c)	read_s(a,b,c)
#define	close(x)	close_s(x)
#endif				/* __WATT32__ */

#ifndef STRCASECMP
int
strcasecmp(char *s1, char *s2)
{
    int x;
    while (*s1) {
	x = tolower(*s1) - tolower(*s2);
	if (x != 0)
	    break;
	s1++;
	s2++;
    }
    if (x != 0)
	return x;
    return -tolower(*s2);
}

int
strncasecmp(char *s1, char *s2, int n)
{
    int x;
    while (*s1 && n) {
	x = tolower(*s1) - tolower(*s2);
	if (x != 0)
	    break;
	s1++;
	s2++;
	n--;
    }
    if (x != 0)
	return x;
    return 0;
}
#endif				/* not STRCASECMP */

int
arg_is(char *str, char *tag)
{
    while (*tag) {
	if (tolower(*tag) != tolower(*str))
	    return 0;
	tag++;
	str++;
    }
    while (*str && (*str == ' ' || *str == '\t'))
	str++;
    return (*str == '=');
}


int
bpcmp(BufferPoint p1, BufferPoint p2)
{
    if (p1.line < p2.line)
	return -1;
    if (p1.line > p2.line)
	return 1;
    if (p1.pos < p2.pos)
	return -1;
    if (p1.pos > p2.pos)
	return 1;
    return 0;
}

int
columnSkip(Buffer * buf, int offset)
{
    int i, len, maxColumn;
    int column = buf->currentColumn + offset;
    int nlines = LASTLINE + 1;
    Line *l;

    maxColumn = 0;
    for (i = 0, l = buf->topLine;
	 i < nlines && l != NULL;
	 i++, l = l->next) {
	len = COLPOS(l, l->len - 1);
	if (len > maxColumn)
	    maxColumn = len;
    }
    maxColumn -= COLS - 1;
    if (column < maxColumn)
	maxColumn = column;
    if (maxColumn < 0)
	maxColumn = 0;

    if (buf->currentColumn == maxColumn)
	return 0;
    buf->currentColumn = maxColumn;
    return 1;
}

int
columnPos(Line * line, int column)
{
    int i;

    for (i = 1; i < line->len; i++) {
	if (COLPOS(line, i) > column) {
#ifdef JP_CHARSET
	    if (CharType(line->propBuf[i - 1]) == PC_KANJI2)
		return i - 2;
#endif
	    return i - 1;
	}
    }
    return i - 1;
}

Line *
lineSkip(Buffer * buf, Line * line, int offset, int last)
{
    int i, n;
    Line *l = line, *line_p;
    int linelen = 0;

    if (buf->pagerSource && strcmp(buf->buffername, CPIPEBUFFERNAME)) {
	n = line->linenumber + offset + LASTLINE;
	while ((last || (buf->lastLine->linenumber < n)) &&
	       ((line_p = getNextPage(buf, 1)) != NULL)) {
	    linelen += line_p->len;
	    showProgress(&linelen, &(buf->trbyte));
	}
    }

    if (offset == 0)
	return l;
    if (offset > 0)
	for (i = 0; i < offset && l->next != NULL; i++, l = l->next);
    else
	for (i = 0; i < -offset && l->prev != NULL; i++, l = l->prev);
    return l;
}

#define MAX_CMD_LEN 128

static int
get_cmd(Hash_si * hash,
	char **s,
	char *args,
	char termchar,
	int defaultcmd,
	int allow_space,
	int *status)
{
    char cmdstr[MAX_CMD_LEN];
    char *p = cmdstr;
    char *save = *s;
    int cmd;
    if (status)
	*status = 0;
    (*s)++;
    while ((IS_ALNUM(**s) || **s == '_' || **s == '/') &&
	   p - cmdstr < MAX_CMD_LEN) {
	*(p++) = tolower(*((*s)++));
    }
    if (p - cmdstr == MAX_CMD_LEN) {
	/* buffer overflow: perhaps caused by bad HTML source */
	*s = save + 1;
	*status = -1;
	return defaultcmd;
    }
    *p = '\0';

    /* hash search */
    cmd = getHash_si(hash, cmdstr, defaultcmd);
    if (args != NULL) {
	p = args;
	while (**s == ' ' || **s == '\t')
	    (*s)++;
	while (**s && **s != '\n' && **s != '\r' && **s != termchar) {
	    *(p++) = *((*s)++);
	}
	*p = '\0';
    }
    else if (allow_space) {
	while (**s && **s != termchar)
	    (*s)++;
    }
    if (**s == termchar)
	(*s)++;
    else if (status)
	*status = -1;
    return cmd;
}

int
gethtmlcmd(char **s, int *status)
{
    extern Hash_si tagtable;
    return get_cmd(&tagtable, s, NULL, '>', HTML_UNKNOWN, 1, status);
}

static char *
searchAnchorArg(char **arg)
{
    char *p;
    if (**arg == '"') {
	(*arg)++;
	p = *arg;
	while (*p && *p != '"')
	    p++;
    }
    else {
	p = *arg;
	while (*p && *p != '>' && *p != ' ' && *p != ',' &&
	       *p != '\t' && *p != '\n')
	    p++;
    }
    return p;
}

char *
getAnchor(char *arg, char **arg_return)
{
    char *p;
    char buf[LINELEN];

    if (arg_is(arg, "name")) {
	arg += 4;
	while (*arg && (*arg == ' ' || *arg == '\t'))
	    arg++;
	if (*arg != '=')
	    return NULL;
	arg++;
	while (*arg && (*arg == ' ' || *arg == '\t'))
	    arg++;
	p = searchAnchorArg(&arg);
	buf[0] = '#';
	strncpy(&buf[1], arg, p - arg);
	if (arg_return)
	    *arg_return = p;
	return allocStr(buf, p - arg + 1);
    }
    while (*arg && *arg != '=')
	arg++;
    if (*arg == '\0')
	return NULL;
    arg++;
    while (*arg && (*arg == ' ' || *arg == '\t'))
	arg++;
    p = searchAnchorArg(&arg);
    if (arg_return)
	*arg_return = p;
    if (p == arg)
	return allocStr(" ", 1);
    return allocStr(arg, p - arg);
}

/* 
 * Check character type
 */

Str
checkType(char *istr, Lineprop * oprop, int len)
{
    Lineprop mode = PC_ASCII, prev_mode;
    Lineprop effect = PE_NORMAL, leffect = PE_NORMAL;
    Lineprop *prop = oprop;
    char *str = istr;
    Str s = Strnew();

    while (*str != '\0') {
	if (prop - oprop >= len)
	    break;
	leffect = effect;
	if (ShowEffect
#ifdef JP_CHARSET
	    && mode != PC_KANJI1
#endif				/* JP_CHARSET */
	    ) {
	    if (!strncmp(str, "_\b", 2)) {
		str += 2;
		effect = PE_UNDER;
		continue;
	    }
	    else if (!strncmp(str, "__\b\b", 4)) {
		str += 4;
		effect = PE_UNDER;
		continue;
	    }
	    else if (!strncmp(str, "\b_", 2)) {
#ifdef JP_CHARSET
		if (s->length > 1 && CharType(*(prop - 2)) == PC_KANJI1) {
		    str += 2;
		    *(prop - 1) |= PE_UNDER;
		    *(prop - 2) |= PE_UNDER;
		}
		else
#endif				/* JP_CHARSET */
		if (s->length > 0) {
		    str += 2;
		    *(prop - 1) |= PE_UNDER;
		}
		else {
		    str++;
		}
		continue;
	    }
	    else if (!strncmp(str, "\b\b__", 4)) {
#ifdef JP_CHARSET
		if (s->length > 1 && CharType(*(prop - 2)) == PC_KANJI1) {
		    str += 4;
		    *(prop - 1) |= PE_UNDER;
		    *(prop - 2) |= PE_UNDER;
		}
		else
#endif				/* JP_CHARSET */
		if (s->length > 0) {
		    str += 3;
		    *(prop - 1) |= PE_UNDER;
		}
		else {
		    str += 2;
		}
		continue;
	    }
	    else if (!strncmp(str, "\b\b", 2)) {
#ifdef JP_CHARSET
		if (s->length > 1 && CharType(*(prop - 2)) == PC_KANJI1) {
		    if (!strncmp(str - 2, str + 2, 2)) {
			*(prop - 1) |= PE_BOLD;
			*(prop - 2) |= PE_BOLD;
			str += 4;
		    }
		    else {
			Strshrink(s, 2);
			prop -= 2;
			str += 2;
		    }
		}
		else
#endif				/* JP_CHARSET */
		if (s->length > 0) {
		    if (*(str - 1) == *(str + 2)) {
			*(prop - 1) |= PE_BOLD;
			str += 3;
		    }
		    else {
			Strshrink(s, 1);
			prop--;
			str += 2;
		    }
		}
		else {
		    str += 2;
		}
		continue;
	    }
	    else if (*str == '\b') {
#ifdef JP_CHARSET
		if (s->length > 1 && CharType(*(prop - 2)) == PC_KANJI1) {
		    if (!strncmp(str - 2, str + 1, 2)) {
			*(prop - 1) |= PE_BOLD;
			*(prop - 2) |= PE_BOLD;
			str += 3;
		    }
		    else {
			Strshrink(s, 2);
			prop -= 2;
			str++;
		    }
		}
		else
#endif				/* JP_CHARSET */
		if (s->length > 0) {
		    if (*(str - 1) == *(str + 1)) {
			*(prop - 1) |= PE_BOLD;
			str += 2;
		    }
		    else {
			Strshrink(s, 1);
			prop--;
			str++;
		    }
		}
		else {
		    str++;
		}
		continue;
	    }
	}

	prev_mode = mode;
	mode = get_ctype((unsigned char) *str, prev_mode);
#ifdef JP_CHARSET
	if (prev_mode == PC_KANJI1 && mode != PC_KANJI2) {
	    *(prop - 1) &= ~P_CHARTYPE;
	    *(prop - 1) |= PC_ASCII;
	}
	if (mode == PC_KANJI2)
	    *(prop++) = (leffect | mode);
	else
#endif				/* JP_CHARSET */
	    *(prop++) = (effect | mode);
	Strcat_char(s, *(str++));
#ifdef JP_CHARSET
	if (mode != PC_KANJI1)
#endif				/* JP_CHARSET */
	    effect = PE_NORMAL;
    }
    return s;
}

int
calcPosition(char *l, int pos, int bpos, int mode)
{
    static short realColumn[LINELEN];
    static char *prevl = NULL;
    int i, j;

    if (l == NULL || *l == '\0')
	return bpos;
    if (l == prevl && mode == CP_AUTO) {
        if (pos <= strlen(l))
	return realColumn[pos];
    }
    prevl = l;
    j = bpos;
    for (i = 0;; i++) {
	realColumn[i] = j;
        if (l[i] == '\0')
            break;
	if (l[i] == '\t')
	    j = (j + Tabstop) / Tabstop * Tabstop;
	else if ((!(l[i] & ~0x1f) && l[i] != CTRL_J) || l[i] == DEL_CODE)
	    j = j + 2;
	else
	    j++;
    }
    if (pos >= i)
	return j;
    return realColumn[pos];
}

char *
lastFileName(char *path)
{
    char *p, *q;

    p = q = path;
    while (*p != '\0') {
	if (*p == '/')
	    q = p + 1;
	p++;
    }

    return allocStr(q, 0);
}

#ifdef NOBCOPY
void
bcopy(void *src, void *dest, int len)
{
    int i;
    if (src == dest)
	return;
    if (src < dest) {
	for (i = len - 1; i >= 0; i--)
	    dest[i] = src[i];
    }
    else {			/* src > dest */
	for (i = 0; i < len; i++)
	    dest[i] = src[i];
    }
}

void
bzero(void *ptr, int len)
{
    int i;
    for (i = 0; i < len; i++)
	*(ptr++) = 0;
}
#endif				/* NOBCOPY */

/* fgets() substitute which terminates \n, \r or \n\r */
char *
myfgets(char *ptr, int len, FILE * stream)
{
    int read_len = 0;
    char c, *p = ptr;

    if (feof(stream))
	return NULL;
    while (c = getc(stream), !feof(stream)) {
	*(p++) = c;
	read_len++;
	if (read_len == len - 1)
	    break;
	if (c == '\n')
	    break;
	if (c == '\r') {
	    c = getc(stream);
	    if (!feof(stream) && c != '\n')
		ungetc(c, stream);
	    *(p - 1) = '\n';
	    break;
	}
    }
    ptr[read_len] = '\0';
    return ptr;
}

/* Strfgets() substitute which terminates \n, \r or \n\r */
Str
Strmyfgets(FILE * stream)
{
    char c;
    Str p = Strnew();

    if (feof(stream))
	return p;
    while (c = getc(stream), !feof(stream) && !ferror(stream)) {
	if (c == '\0') {
	    Strcat_charp(p, "^@");
	    continue;
	}
	Strcat_char(p, c);
	if (c == '\n')
	    break;
	if (c == '\r') {
	    c = getc(stream);
	    if (!feof(stream) && c != '\n')
		ungetc(c, stream);
	    p->ptr[p->length - 1] = '\n';
	    break;
	}
    }
    return p;
}

#ifdef JP_CHARSET
Str
Strkconv(Str s, int fcode, int tcode)
{
    if (fcode == tcode)
	return s;
    return conv(s->ptr, fcode, tcode);
}
#endif				/* JP_CHARSET */

char *
mybasename(char *s)
{
    char *p = s;
    while (*p)
	p++;
    while (s <= p && *p != '/')
	p--;
    if (*p == '/')
	p++;
    else
	p = s;
    return allocStr(p, 0);
}

#ifndef STRERROR
char *
strerror(int errno)
{
    extern char *sys_errlist[];
    return sys_errlist[errno];
}
#endif				/* not STRERROR */

#ifndef SYS_ERRLIST
char **sys_errlist;

prepare_sys_errlist()
{
    int i, n;

    i = 1;
    while (strerror(i) != NULL)
	i++;
    n = i;
    sys_errlist = New_N(char *, n);
    sys_errlist[0] = "";
    for (i = 1; i < n; i++)
	sys_errlist[i] = strerror(i);
}
#endif				/* not SYS_ERRLIST */

int
next_status(char c, int *status)
{
    switch (*status) {
    case R_ST_NORMAL:
	if (c == '<') {
	    *status = R_ST_TAG0;
	    return 0;
	}
	else if (c == '&') {
	    *status = R_ST_AMP;
	    return 1;
	}
	else
	    return 1;
	break;
    case R_ST_TAG0:
	if (c == '!') {
	    *status = R_ST_CMNT1;
	    return 0;
	}
	*status = R_ST_TAG;
	/* continues to next case */
    case R_ST_TAG:
	if (c == '>')
	    *status = R_ST_NORMAL;
	else if (c == '=')
	    *status = R_ST_EQL;
	return 0;
    case R_ST_EQL:
	if (c == '"')
	    *status = R_ST_DQUOTE;
	else if (c == '\'')
	    *status = R_ST_QUOTE;
	else if (IS_SPACE(c))
	    *status = R_ST_EQL;
	else if (c == '>')
	    *status = R_ST_NORMAL;
	else
	    *status = R_ST_TAG;
	return 0;
    case R_ST_QUOTE:
	if (c == '\'')
	    *status = R_ST_TAG;
	return 0;
    case R_ST_DQUOTE:
	if (c == '"')
	    *status = R_ST_TAG;
	return 0;
    case R_ST_AMP:
	if (c == ';') {
	    *status = R_ST_NORMAL;
	    return 0;
	}
	else if (c != '#' && !IS_ALNUM(c) && c != '_') {
	    /* something's wrong! */
	    *status = R_ST_NORMAL;
	    return 0;
	}
	else
	    return 0;
    case R_ST_CMNT1:
	switch (c) {
	case '-':
	    *status = R_ST_CMNT2;
	    break;
	case '>':
	    *status = R_ST_NORMAL;
	    break;
	default:
	    *status = R_ST_IRRTAG;
	}
	return 0;
    case R_ST_CMNT2:
	switch (c) {
	case '-':
	    *status = R_ST_CMNT;
	    break;
	case '>':
	    *status = R_ST_NORMAL;
	    break;
	default:
	    *status = R_ST_IRRTAG;
	}
	return 0;
    case R_ST_CMNT:
	if (c == '-')
	    *status = R_ST_NCMNT1;
	return 0;
    case R_ST_NCMNT1:
	if (c == '-')
	    *status = R_ST_NCMNT2;
	else
	    *status = R_ST_CMNT;
	return 0;
    case R_ST_NCMNT2:
	switch (c) {
	case '>':
	    *status = R_ST_NORMAL;
	    break;
	case '-':
	    *status = R_ST_NCMNT2;
	    break;
	default:
	    if (IS_SPACE(c))
		*status = R_ST_NCMNT3;
	    else
		*status = R_ST_CMNT;
	    break;
	}
	break;
    case R_ST_NCMNT3:
	switch (c) {
	case '>':
	    *status = R_ST_NORMAL;
	    break;
	case '-':
	    *status = R_ST_NCMNT1;
	    break;
	default:
	    if (IS_SPACE(c))
		*status = R_ST_NCMNT3;
	    else
		*status = R_ST_CMNT;
	    break;
	}
	return 0;
    case R_ST_IRRTAG:
	if (c == '>')
	    *status = R_ST_NORMAL;
	return 0;
    }
    /* notreached */
    return 0;
}

int
read_token(Str buf, char **instr, int *status, int pre, int append)
{
    char *p;
    int prev_status;

    if (**instr == '\0')
	return 0;
    if (!append)
	Strclear(buf);
    for (p = *instr; *p; p++) {
	prev_status = *status;
	next_status(*p, status);
	switch (*status) {
	case R_ST_NORMAL:
	    if (prev_status == R_ST_AMP && *p != ';') {
		p--;
		break;
	    }
	    if (prev_status == R_ST_NCMNT2 || prev_status == R_ST_NCMNT3 ||
		prev_status == R_ST_IRRTAG || prev_status == R_ST_CMNT1) {
		if (prev_status == R_ST_CMNT1 && !append)
		    Strclear(buf);
		p++;
		goto proc_end;
	    }
	    if (*p == ' ' || *p == '\t') {
		if (pre)
		    Strcat_char(buf, *p);
		else
		    Strcat_char(buf, ' ');
	    }
	    else if (*p == '\n' || *p == '\r') {
		if (pre) {
		    if ((p[0] == '\n' && p[1] == '\r') ||
			(p[0] == '\r' && p[1] == '\n'))
			p++;
		    Strcat_char(buf, '\n');
		}
		else
		    Strcat_char(buf, ' ');
	    }
	    else
		Strcat_char(buf, *p);
	    if (ST_IS_REAL_TAG(prev_status)) {
		*instr = p + 1;
		if (buf->length < 2 ||
		    buf->ptr[buf->length - 2] != '<' ||
		    buf->ptr[buf->length - 1] != '>')
		    return 1;
		Strshrink(buf, 2);
	    }
	    break;
	case R_ST_TAG0:
	case R_ST_TAG:
	    if (prev_status == R_ST_NORMAL && p != *instr) {
		*instr = p;
		*status = prev_status;
		return 1;
	    }
	    if (*status == R_ST_TAG0 &&
		!REALLY_THE_BEGINNING_OF_A_TAG(p)) {
		/* it seems that this '<' is not a beginning of a tag */
		Strcat_charp(buf, "&lt;");
		*status = R_ST_NORMAL;
	    }
	    else
		Strcat_char(buf, *p);
	    break;
	case R_ST_EQL:
	case R_ST_QUOTE:
	case R_ST_DQUOTE:
	case R_ST_AMP:
	    Strcat_char(buf, *p);
	    break;
	case R_ST_CMNT:
	case R_ST_IRRTAG:
	    if (!append)
		Strclear(buf);
	    break;
	case R_ST_CMNT1:
	case R_ST_CMNT2:
	case R_ST_NCMNT1:
	case R_ST_NCMNT2:
	case R_ST_NCMNT3:
	    /* do nothing */
	    break;
	}
    }
  proc_end:
    *instr = p;
    return 1;
}

/* authentication */
struct auth_cookie *
find_auth(char *host, char *realm)
{
    struct auth_cookie *p;

    for (p = Auth_cookie; p != NULL; p = p->next) {
	if (!Strcasecmp_charp(p->host, host) &&
	    !Strcasecmp_charp(p->realm, realm))
	    return p;
    }
    return NULL;
}

Str
find_auth_cookie(char *host, char *realm)
{
    struct auth_cookie *p = find_auth(host, realm);
    if (p)
	return p->cookie;
    return NULL;
}

void
add_auth_cookie(char *host, char *realm, Str cookie)
{
    struct auth_cookie *p;

    p = find_auth(host, realm);
    if (p) {
	p->cookie = cookie;
	return;
    }
    p = New(struct auth_cookie);
    p->host = Strnew_charp(host);
    p->realm = Strnew_charp(realm);
    p->cookie = cookie;
    p->next = Auth_cookie;
    Auth_cookie = p;
}

/* get last modified time */
char *
last_modified(Buffer * buf)
{
    TextListItem *ti;
    struct stat st;

    if (buf->document_header) {
	for (ti = buf->document_header->first; ti; ti = ti->next) {
	    if (strncasecmp(ti->ptr, "Last-modified: ", 15) == 0) {
		return ti->ptr + 15;
	    }
	}
	return "unknown";
    }
    else if (buf->currentURL.scheme == SCM_LOCAL) {
	if (stat(buf->currentURL.file, &st) < 0)
	    return "unknown";
	return ctime(&st.st_mtime);
    }
    return "unknown";
}

int
is_kanji1(unsigned char ch, char code)
{
    switch (code) {
    case 'E':
	if (ch >= 0xa1 && ch <= 0xfe)
	    return 1;
	else
	    return 0;
    case 'S':
	if ((ch >= 0x81 && ch <= 0x9f) || (ch >= 0xe0 && ch <= 0xfc))
	    return 1;
	else
	    return 0;
    }
    return 0;
}

int
is_kanji2(unsigned char ch, char code)
{
    switch (code) {
    case 'E':
	if (ch >= 0xa1 && ch <= 0xfe)
	    return 1;
	else
	    return 0;
    case 'S':
	if ((ch >= 0x40 && ch <= 0x7e) || (ch >= 0x80 && ch <= 0xfc))
	    return 1;
	else
	    return 0;
    }
    return 0;
}

Lineprop
get_ctype(unsigned char ch, Lineprop prev_mode)
{
#ifdef JP_CHARSET
    if (prev_mode == PC_KANJI1 && is_kanji2(ch, InnerCode))
	return PC_KANJI2;

    if (is_kanji1(ch, InnerCode))
	return PC_KANJI1;
    else
#endif				/* JP_CHARSET */
    if (!(ch & ~0x1f))
	return PC_CTRL;
    else
	return PC_ASCII;
}

static char roman_num1[] =
{
    'i', 'x', 'c', 'm', '*',
};
static char roman_num5[] =
{
    'v', 'l', 'd', '*',
};

static Str
romanNum2(int l, int n)
{
    Str s = Strnew();

    switch (n) {
    case 1:
    case 2:
    case 3:
	for (; n > 0; n--)
	    Strcat_char(s, roman_num1[l]);
	break;
    case 4:
	Strcat_char(s, roman_num1[l]);
	Strcat_char(s, roman_num5[l]);
	break;
    case 5:
    case 6:
    case 7:
    case 8:
	Strcat_char(s, roman_num5[l]);
	for (n -= 5; n > 0; n--)
	    Strcat_char(s, roman_num1[l]);
	break;
    case 9:
	Strcat_char(s, roman_num1[l]);
	Strcat_char(s, roman_num1[l + 1]);
	break;
    }
    return s;
}

Str
romanNumeral(int n)
{
    Str r = Strnew();

    if (n <= 0)
	return r;
    if (n >= 4000) {
	Strcat_charp(r, "**");
	return r;
    }
    Strcat(r, romanNum2(3, n / 1000));
    Strcat(r, romanNum2(2, (n % 1000) / 100));
    Strcat(r, romanNum2(1, (n % 100) / 10));
    Strcat(r, romanNum2(0, n % 10));

    return r;
}

Str
romanAlphabet(int n)
{
    Str r = Strnew();
    int l;
    char buf[14];

    if (n <= 0)
	return r;

    l = 0;
    while (n) {
	buf[l++] = 'a' + (n - 1) % 26;
	n = (n - 1) / 26;
    }
    l--;
    for (; l >= 0; l--)
	Strcat_char(r, buf[l]);

    return r;
}

#ifdef USE_SSL
SSLStream
newSSLStream(SSL * handle, int sock)
{
    SSLStream ss;
    if (sock < 0)
	return NULL;
    ss = New(struct ssl_stream);
    ss->pos = ss->epos = 0;
    ss->handle = handle;
    ss->sock = sock;
    ss->status = -1;
    ss->bufsize = SSL_BUF_SIZE;
    ss->buf = NewAtom_N(char, ss->bufsize);
    return ss;
}

void
SSclose(SSLStream ss)
{
    if (!ss)
	return;

    close(ss->sock);
    if (ss->handle)
	SSL_free(ss->handle);
}

static int
SSgetc(SSLStream ss)
{
    if (ss->epos <= ss->pos) {
	ss->pos = ss->epos = 0;
	if (ss->handle) {
#ifdef USE_SSL_VERIFY
	    for (;;) {
		ss->status = SSL_read(ss->handle, ss->buf, ss->bufsize);
		if (ss->status > 0)
		    break;
		switch (SSL_get_error(ss->handle, ss->status)) {
		case SSL_ERROR_WANT_READ:
		    continue;
		default:
		    break;
		}
		break;
	    }
#else				/* if !defined(USE_SSL_VERIFY) */
	    ss->status = SSL_read(ss->handle, ss->buf, ss->bufsize);
#endif				/* !defined(USE_SSL_VERIFY) */
	}
	else
	    ss->status = read(ss->sock, ss->buf, ss->bufsize);
	if (ss->status <= 0) {
	    return '\0';
	}
	ss->epos += ss->status;
    }
    return ss->buf[ss->pos++];
}

static int
SSundogetc(SSLStream ss)
{
    if (ss && ss->pos > 0) {
	ss->pos--;
	return 0;
    }
    return -1;
}

Str
StrSSgets(SSLStream ss)
{
    char c = '\0';
    Str p = Strnew();

    if (!ss)
	return p;

    while (c = SSgetc(ss), ss->status > 0) {
	Strcat_char(p, c);
	if (c == '\n')
	    break;
    }
    return p;
}

Str
StrmySSgets(SSLStream ss)
{
    char c = '\0';
    Str p = Strnew();

    if (!ss)
	return p;

    while (c = SSgetc(ss), ss->status > 0) {
	if (c == '\0') {
	    Strcat_charp(p, "^@");
	    continue;
	}
	Strcat_char(p, c);
	if (c == '\n')
	    break;
	if (c == '\r') {
	    c = SSgetc(ss);
	    if (ss->status > 0 && c != '\n')
		SSundogetc(ss);
	    p->ptr[p->length - 1] = '\n';
	    break;
	}
    }
    return p;
}
#endif				/* USE_SSL */

static Str
sgets(char **str)
{
    int i;
    Str ptr = Strnew();
    char c;

    if (*str == NULL)
	return ptr;

    for (i = 0; (*str)[i]; i++) {
	c = (*str)[i];
	Strcat_char(ptr, c);
	if (c == '\n') {
	    (*str) += i + 1;
	    return ptr;
	}
    }
    (*str) += i;
    return ptr;
}

Str
StrUFgets(URLFile * f)
{
    Str s = NULL;

    switch (f->stream_type) {
    case SMT_STRING:
	s = sgets(&f->stream.is);
	if (!f->stream.is || f->stream.is[0] == '\0')
	    f->iseof = TRUE;
	break;
#ifdef USE_SSL
    case SMT_SSL:
	s = StrSSgets(f->stream.ss);
	if (!f->stream.ss || f->stream.ss->status <= 0)
	    f->iseof = TRUE;
	break;
#endif				/* USE_SSL */
    case SMT_FILE:
    default:
	s = Strfgets(f->stream.f);
	if (!f->stream.f || feof(f->stream.f) || ferror(f->stream.f))
	    f->iseof = TRUE;
	break;
    }

    return s;
}

Str
StrmyUFgets(URLFile * f)
{
    Str s = NULL;

    switch (f->stream_type) {
    case SMT_STRING:
	s = sgets(&f->stream.is);
	if (!f->stream.is || f->stream.is[0] == '\0')
	    f->iseof = TRUE;
	break;
#ifdef USE_SSL
    case SMT_SSL:
	s = StrmySSgets(f->stream.ss);
	if (!f->stream.ss || f->stream.ss->status <= 0)
	    f->iseof = TRUE;
	break;
#endif				/* USE_SSL */
    case SMT_FILE:
    default:
	s = Strmyfgets(f->stream.f);
	if (!f->stream.f || feof(f->stream.f) || ferror(f->stream.f))
	    f->iseof = TRUE;
	break;
    }

    return s;
}

static int _prev_c = '\0';
int
UFgetc(URLFile * f)
{
    switch (f->stream_type) {
    case SMT_STRING:
	if (f->stream.is)
	    _prev_c = *(f->stream.is++);
	if (!f->stream.is || f->stream.is[0] == '\0')
	    f->iseof = TRUE;
	break;
#ifdef USE_SSL
    case SMT_SSL:
	if (f->stream.ss)
	    _prev_c = SSgetc(f->stream.ss);
	if (!f->stream.ss || f->stream.ss->status <= 0)
	    f->iseof = TRUE;
	break;
#endif				/* USE_SSL */
    case SMT_FILE:
    default:
	if (f->stream.f)
	    _prev_c = getc(f->stream.f);
	if (!f->stream.f || feof(f->stream.f) || ferror(f->stream.f))
	    f->iseof = TRUE;
	break;
    }
    return _prev_c;
}

void
UFundogetc(URLFile * f)
{
    switch (f->stream_type) {
    case SMT_STRING:
	if (f->stream.is)
	    f->stream.is--;
	break;
#ifdef USE_SSL
    case SMT_SSL:
	if (f->stream.ss)
	    SSundogetc(f->stream.ss);
	break;
#endif				/* USE_SSL */
    case SMT_FILE:
    default:
	if (f->stream.f)
	    ungetc(_prev_c, f->stream.f);
	break;
    }
}

void
UFclose0(URLFile * f, void (*closep) ())
{
    if (!f->stream.f)
	return;
    switch (f->stream_type) {
    case SMT_STRING:
	break;
#ifdef USE_SSL
    case SMT_SSL:
	SSclose(f->stream.ss);
	break;
#endif				/* USE_SSL */
    case SMT_FILE:
    default:
	if (closep)
	    closep(f->stream.f);
	break;
    }
}

void
UFclose(URLFile * f)
{
    UFclose0(f, f->close);
}

Str
quoteShell(char *string)
{
    Str str = Strnew();

    while (*string != '\0') {
	if (!IS_ALNUM(*string) && *string != '_' && *string != '.' &&
	    *string != ':' && *string != '/')
	    Strcat_char(str, '\\');
	Strcat_char(str, *(string++));
    }
    return str;
}

void
mySystem(char *command, int background)
{
    Str cmd = Strnew_charp(command);
    if (background)
	Strcat_char(cmd, '&');
    system(cmd->ptr);
}

char *
expandName(char *name)
{
    Str userName = NULL;
    char *p;
    struct passwd *passent, *getpwnam(const char *);
    Str extpath = Strnew();

    p = name;
    if (*p == '/' && *(p + 1) == '~' && IS_ALPHA(*(p + 2))) {
	if (personal_document_root != NULL) {
	    userName = Strnew();
	    p += 2;
	    while (IS_ALNUM(*p) || *p == '_' || *p == '-')
		Strcat_char(userName, *(p++));
	    passent = getpwnam(userName->ptr);
	    if (passent == NULL) {
		p = name;
		goto rest;
	    }
	    Strcat_charp(extpath, passent->pw_dir);
	    Strcat_char(extpath, '/');
	    Strcat_charp(extpath, personal_document_root);
	    if (Strcmp_charp(extpath, "/") == 0 && *p == '/')
		p++;
	}
    }
    else
	p = expandPath(p);
  rest:
    Strcat_charp(extpath, p);
    return extpath->ptr;
}

#ifdef USE_COOKIE
static char *monthtbl[] =
{
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

static int
get_day(char **s)
{
    Str tmp = Strnew();
    int day;
    char *ss = *s;

    if (!**s)
	return -1;

    while (**s && isdigit((unsigned char) **s))
	Strcat_char(tmp, *((*s)++));

    day = atoi(tmp->ptr);

    if (day < 1 || day > 31) {
	*s = ss;
	return -1;
    }
    return day;
}

static int
get_month(char **s)
{
    Str tmp = Strnew();
    int mon;
    char *ss = *s;

    if (!**s)
	return -1;

    while (**s && isdigit((unsigned char) **s))
	Strcat_char(tmp, *((*s)++));
    if (tmp->length > 0) {
	mon = atoi(tmp->ptr);
    }
    else {
	while (**s && isalpha((unsigned char) **s))
	    Strcat_char(tmp, *((*s)++));
	for (mon = 1; mon <= 12; mon++) {
	    if (strncmp(tmp->ptr, monthtbl[mon - 1], 3) == 0)
		break;
	}
    }
    if (mon < 1 || mon > 12) {
	*s = ss;
	return -1;
    }
    return mon;
}

static int
get_year(char **s)
{
    Str tmp = Strnew();
    int year;
    char *ss = *s;

    if (!**s)
	return -1;

    while (**s && isdigit((unsigned char) **s))
	Strcat_char(tmp, *((*s)++));
    if (tmp->length != 2 && tmp->length != 4) {
	*s = ss;
	return -1;
    }

    year = atoi(tmp->ptr);
    if (tmp->length == 2) {
	if (year >= 70)
	    year += 1900;
	else
	    year += 2000;
    }
    return year;
}

static int
get_time(char **s, int *hour, int *min, int *sec)
{
    Str tmp = Strnew();
    char *ss = *s;

    if (!**s)
	return -1;

    while (**s && isdigit((unsigned char) **s))
	Strcat_char(tmp, *((*s)++));
    if (**s != ':') {
	*s = ss;
	return -1;
    }
    *hour = atoi(tmp->ptr);

    (*s)++;
    Strclear(tmp);
    while (**s && isdigit((unsigned char) **s))
	Strcat_char(tmp, *((*s)++));
    if (**s != ':') {
	*s = ss;
	return -1;
    }
    *min = atoi(tmp->ptr);

    (*s)++;
    Strclear(tmp);
    while (**s && isdigit((unsigned char) **s))
	Strcat_char(tmp, *((*s)++));
    *sec = atoi(tmp->ptr);

    if (*hour < 0 || *hour >= 24 ||
	*min < 0 || *min >= 60 ||
	*sec < 0 || *sec >= 60) {
	*s = ss;
	return -1;
    }
    return 0;
}

/* RFC 1123 or RFC 850 or ANSI C asctime() format string -> time_t */
time_t
mymktime(char *timestr)
{
    char *s;
    int day, mon, year, hour, min, sec;

    if (!(timestr && *timestr))
	return -1;
    s = timestr;

#ifdef DEBUG
    fprintf(stderr, "mktime: %s\n", timestr);
#endif				/* DEBUG */

    while (*s && isalpha((unsigned char) *s))
	s++;
    while (*s && !isalnum((unsigned char) *s))
	s++;

    if (isdigit(*s)) {
	/* RFC 1123 or RFC 850 format */
	if ((day = get_day(&s)) == -1)
	    return -1;

	while (*s && !isalnum((unsigned char) *s))
	    s++;
	if ((mon = get_month(&s)) == -1)
	    return -1;

	while (*s && !isdigit((unsigned char) *s))
	    s++;
	if ((year = get_year(&s)) == -1)
	    return -1;

	while (*s && !isdigit((unsigned char) *s))
	    s++;
	if (!*s) {
	    hour = 0;
	    min = 0;
	    sec = 0;
	}
	else if (get_time(&s, &hour, &min, &sec) == -1) {
	    return -1;
	}
    }
    else {
	/* ANSI C asctime() format. */
	while (*s && !isalnum((unsigned char) *s))
	    s++;
	if ((mon = get_month(&s)) == -1)
	    return -1;

	while (*s && !isdigit((unsigned char) *s))
	    s++;
	if ((day = get_day(&s)) == -1)
	    return -1;

	while (*s && !isdigit((unsigned char) *s))
	    s++;
	if (get_time(&s, &hour, &min, &sec) == -1)
	    return -1;

	while (*s && !isdigit((unsigned char) *s))
	    s++;
	if ((year = get_year(&s)) == -1)
	    return -1;
    }
#ifdef DEBUG
    fprintf(stderr, "year=%d month=%d day=%d hour:min:sec=%d:%d:%d\n",
	    year, mon, day, hour, min, sec);
#endif				/* DEBUG */

    mon -= 3;
    if (mon < 0) {
	mon += 12;
	year--;
    }
    day += (year - 1968) * 1461 / 4;
    day += ((((mon * 153) + 2) / 5) - 672);
    return (time_t) ((day * 60 * 60 * 24) +
		     (hour * 60 * 60) +
		     (min * 60) +
		     sec);
}

#ifdef INET6
#include <sys/socket.h>
#endif				/* INET6 */
#include <netdb.h>
char *
FQDN(char *host)
{
    char *p;
#ifndef INET6
    struct hostent *entry;
#else				/* INET6 */
    int *af;
#endif				/* INET6 */

    if (host == NULL)
	return NULL;

    for (p = host; *p && *p != '.'; p++);

    if (*p == '.')
	return host;

#ifndef INET6
    if (!(entry = gethostbyname(host)))
	return NULL;

    return allocStr(entry->h_name, 0);
#else				/* INET6 */
    for (af = ai_family_order_table[DNS_order];; af++) {
	int error;
	struct addrinfo hints;
	struct addrinfo *res, *res0;
	char *namebuf;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = *af;
	hints.ai_socktype = SOCK_STREAM;
	error = getaddrinfo(host, NULL, &hints, &res0);
	if (error) {
	    if (*af == PF_UNSPEC) {
		/* all done */
		break;
	    }
	    /* try next address family */
	    continue;
	}
	for (res = res0; res != NULL; res = res->ai_next) {
	    if (res->ai_canonname) {
		/* found */
		namebuf = strdup(res->ai_canonname);
		freeaddrinfo(res0);
		return namebuf;
	    }
	}
	freeaddrinfo(res0);
	if (*af == PF_UNSPEC) {
	    break;
	}
    }
    /* all failed */
    return NULL;
#endif				/* INET6 */
}

#endif				/* USE_COOKIE */
