#ifndef FILE_H
#define FILE_H

#include <qdir.h>

enum LoadMode {NewMap,ImportAdd,ImportReplace};
enum SaveMode {PartOfMap,CompleteMap,UndoCommand};
enum ErrorCode {success,aborted,nozip};


/////////////////////////////////////////////////////////////////////////////
QString maskPath (QString );
QString convertToRel (const QString &,const QString &);
QString makeUniqueDir (QString);
void removeDir(QDir);
void makeSubDirs (const QString &);
ErrorCode zipDir (const QDir &,const QString&);
ErrorCode unzipDir (const QDir &,const QString&);
bool loadStringFromDisk (const QString &, QString &);
bool saveStringToDisk (const QString &, const QString &s);

/////////////////////////////////////////////////////////////////////////////
#include <qlabel.h>
#include <qfiledialog.h>
#include <qpixmap.h>

class ImagePreview : public QLabel, public QFilePreview
{
public:
    ImagePreview( QWidget * );
    void previewUrl( const QUrl & );
protected:
	QFileDialog *fdia;
};

#endif
