/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
void EditXLinkDialog::init()
{
	delink=false;
	xlo=false;
	selection=NULL;
}

void EditXLinkDialog::deleteButtonPressed()
{
	delink=true;
	accept();
}

bool EditXLinkDialog::deleteXLink()
{
	return delink;
}	


void EditXLinkDialog::widthChanged( int  w)
{
	xlo->setWidth(w);
}

void EditXLinkDialog::setXLink( XLinkObj * xo)
{
	xlo=xo;
	colorButton->setPaletteBackgroundColor (xlo->getColor() );
	widthBox->setValue(xlo->getWidth());
}

void EditXLinkDialog::setSelection(LinkableMapObj *s)
{
	selection=s;
}

void EditXLinkDialog::colorButtonPressed()
{
	if (xlo)
	{	
		QColor col = QColorDialog::getColor(xlo->getColor(), this );
		if ( !col.isValid() ) return;
		xlo->setColor( col );
		colorButton->setPaletteBackgroundColor (col);
	}
}

void EditXLinkDialog::setColorHeadingButtonPressed()
{
	if (xlo)
	{	
		if (selection && 
			(typeid(*selection) == typeid(BranchObj)) || 
			(typeid(*selection) == typeid(MapCenterObj))  )
		{
			QColor col=((BranchObj*)(selection))->getColor();
			xlo->setColor(col);
			colorButton->setPaletteBackgroundColor (col);
		}
	}
}

bool EditXLinkDialog::useSettingsGlobal ()
{
	return useSettings->isChecked();
}
