/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;

public class vncviewer
extends Applet
implements Runnable {
    boolean inAnApplet = true;
    Frame f;
    String[] mainArgs;
    String host;
    int port;
    rfbProto rfb;
    Thread rfbThread;
    GridBagLayout gridbag;
    Panel buttonPanel;
    Button disconnectButton;
    Button optionsButton;
    Button clipboardButton;
    Button ctrlAltDelButton;
    optionsFrame options;
    clipboardFrame clipboard;
    authenticationPanel authenticator;
    boolean gotFocus = false;

    public static void main(String[] stringArray) {
        vncviewer vncviewer2 = new vncviewer();
        vncviewer2.mainArgs = stringArray;
        vncviewer2.inAnApplet = false;
        vncviewer2.f = new Frame("VNC");
        vncviewer2.f.add("Center", vncviewer2);
        vncviewer2.init();
        vncviewer2.start();
    }

    public void init() {
        this.readParameters();
        this.options = new optionsFrame(this);
        this.clipboard = new clipboardFrame(this);
        this.authenticator = new authenticationPanel();
        this.rfbThread = new Thread(this);
        this.rfbThread.start();
    }

    public void update(Graphics graphics) {
    }

    public void run() {
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new FlowLayout(0, 0, 0));
        this.disconnectButton = new Button("Disconnect");
        this.disconnectButton.disable();
        this.buttonPanel.add(this.disconnectButton);
        this.optionsButton = new Button("Options");
        this.buttonPanel.add(this.optionsButton);
        this.clipboardButton = new Button("Clipboard");
        this.clipboardButton.disable();
        this.buttonPanel.add(this.clipboardButton);
        this.ctrlAltDelButton = new Button("Send Ctrl-Alt-Del");
        this.ctrlAltDelButton.disable();
        this.buttonPanel.add(this.ctrlAltDelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.gridbag.setConstraints(this.buttonPanel, gridBagConstraints);
        this.add(this.buttonPanel);
        try {
            this.connectAndAuthenticate();
            this.doProtocolInitialisation();
            vncCanvas vncCanvas2 = new vncCanvas(this);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.gridbag.setConstraints(vncCanvas2, gridBagConstraints);
            this.add(vncCanvas2);
            if (!this.inAnApplet) {
                this.f.setTitle(this.rfb.desktopName);
                this.f.pack();
            } else {
                this.validate();
            }
            this.disconnectButton.enable();
            this.clipboardButton.enable();
            this.ctrlAltDelButton.enable();
            vncCanvas2.processNormalProtocol();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.fatalError(exception.toString());
            return;
        }
    }

    void connectAndAuthenticate() throws IOException {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 50;
        this.gridbag.setConstraints(this.authenticator, gridBagConstraints);
        this.add(this.authenticator);
        this.validate();
        if (!this.inAnApplet) {
            this.f.pack();
            this.f.show();
        }
        boolean bl = false;
        while (!bl) {
            Object object = this.authenticator;
            synchronized (object) {
                try {
                    this.authenticator.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.rfb = new rfbProto(this.host, this.port, this);
            this.rfb.readVersionMsg();
            System.out.println("RFB server supports protocol version " + this.rfb.serverMajor + "." + this.rfb.serverMinor);
            this.rfb.writeVersionMsg();
            block3 : switch (this.rfb.readAuthScheme()) {
                case 1: {
                    System.out.println("No authentication needed");
                    bl = true;
                    break;
                }
                case 2: {
                    object = new byte[16];
                    this.rfb.is.readFully((byte[])object);
                    String string = this.authenticator.password.getText();
                    if (string.length() > 8) {
                        string = string.substring(0, 8);
                    }
                    if (string.length() == 0) {
                        this.authenticator.retry();
                        break;
                    }
                    byte[] byArray = new byte[8];
                    string.getBytes(0, string.length(), byArray, 0);
                    int n = string.length();
                    while (n < 8) {
                        byArray[n] = 0;
                        ++n;
                    }
                    DesCipher desCipher = new DesCipher(byArray);
                    desCipher.encrypt((byte[])object, 0, (byte[])object, 0);
                    desCipher.encrypt((byte[])object, 8, (byte[])object, 8);
                    this.rfb.os.write((byte[])object);
                    int n2 = this.rfb.is.readInt();
                    switch (n2) {
                        case 0: {
                            System.out.println("VNC authentication succeeded");
                            bl = true;
                            break block3;
                        }
                        case 1: {
                            System.out.println("VNC authentication failed");
                            this.authenticator.retry();
                            break block3;
                        }
                        case 2: {
                            throw new IOException("VNC authentication failed - too many tries");
                        }
                    }
                    throw new IOException("Unknown VNC authentication result " + n2);
                }
            }
        }
        this.remove(this.authenticator);
    }

    void doProtocolInitialisation() throws IOException {
        System.out.println("sending client init");
        this.rfb.writeClientInit();
        this.rfb.readServerInit();
        System.out.println("Desktop name is " + this.rfb.desktopName);
        System.out.println("Desktop size is " + this.rfb.framebufferWidth + " x " + this.rfb.framebufferHeight);
        this.setEncodings();
    }

    void setEncodings() {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeSetEncodings(this.options.encodings, this.options.nEncodings);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setCutText(String string) {
        try {
            if (this.rfb != null && this.rfb.inNormalProtocol) {
                this.rfb.writeClientCutText(string);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized boolean action(Event event, Object object) {
        if (event.target == this.optionsButton) {
            if (this.options.isVisible()) {
                ((Component)this.options).hide();
            } else {
                this.options.show();
            }
        } else if (event.target == this.disconnectButton) {
            System.out.println("disconnect");
            this.options.dispose();
            this.clipboard.dispose();
            if (this.inAnApplet) {
                this.removeAll();
                this.rfb.close();
                this.rfb = null;
                Label label = new Label("Disconnected");
                this.setLayout(new FlowLayout(0, 30, 30));
                this.add(label);
                this.validate();
                this.rfbThread.stop();
            } else {
                System.exit(1);
            }
        } else if (event.target == this.clipboardButton) {
            if (this.clipboard.isVisible()) {
                ((Component)this.clipboard).hide();
            } else {
                this.clipboard.show();
            }
        } else if (event.target == this.ctrlAltDelButton) {
            try {
                Event event2 = new Event(null, 0, null);
                event2.key = 127;
                event2.modifiers = 10;
                event2.id = 401;
                this.rfb.writeKeyEvent(event2);
                event2.id = 402;
                this.rfb.writeKeyEvent(event2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public boolean gotFocus(Event event, Object object) {
        this.gotFocus = true;
        return true;
    }

    public boolean lostFocus(Event event, Object object) {
        this.gotFocus = false;
        return true;
    }

    void encryptBytes(byte[] byArray, String string) {
        byte[] byArray2 = new byte[8];
        string.getBytes(0, string.length(), byArray2, 0);
        int n = string.length();
        while (n < 8) {
            byArray2[n] = 0;
            ++n;
        }
        DesCipher desCipher = new DesCipher(byArray2);
        desCipher.encrypt(byArray, 0, byArray, 0);
        desCipher.encrypt(byArray, 8, byArray, 8);
    }

    public void readParameters() {
        this.host = this.readParameter("HOST", !this.inAnApplet);
        if (this.host == null) {
            this.host = this.getCodeBase().getHost();
            if (this.host.equals("")) {
                this.fatalError("HOST parameter not specified");
            }
        }
        String string = this.readParameter("PORT", true);
        this.port = Integer.parseInt(string);
    }

    public String readParameter(String string, boolean bl) {
        if (this.inAnApplet) {
            String string2 = this.getParameter(string);
            if (string2 == null && bl) {
                this.fatalError(String.valueOf(string) + " parameter not specified");
            }
            return string2;
        }
        int n = 0;
        while (n < this.mainArgs.length) {
            if (this.mainArgs[n].equalsIgnoreCase(string)) {
                try {
                    return this.mainArgs[n + 1];
                }
                catch (Exception exception) {
                    if (bl) {
                        this.fatalError(String.valueOf(string) + " parameter not specified");
                    }
                    return null;
                }
            }
            n += 2;
        }
        if (bl) {
            this.fatalError(String.valueOf(string) + " parameter not specified");
        }
        return null;
    }

    public void fatalError(String string) {
        System.out.println(string);
        if (this.inAnApplet) {
            this.removeAll();
            Label label = new Label(string);
            this.setLayout(new FlowLayout(0, 30, 30));
            this.add(label);
            this.validate();
            Thread.currentThread().stop();
            return;
        }
        System.exit(1);
    }
}

