#include <stdio.h>
#include <ctype.h>
#include "string.h"
#include "viz.h"
#include "translate.h"

#ifdef VIZ
extern long count_reg[];
#endif

/* Translates strings containing C escapes.
 * If compiled with -DVIZ, then $x has special meaning
 * as viz comment escape sequence.
 * Stops at newline or \0.
 *
 */

void
viz_decode(s, mode, outbuf)
register char *s;	/* line to translate.  If mode is 'c', s should begin
			 * after the 'c' mode character.
			 */
register char mode;	/* 'c' or 'a' */
char *outbuf;		/* Output buffer; assumed long enough.  Note that
			 * the output will never be longer than the input.
			 */
{
    char *outbuf_p = outbuf;
    register unsigned char c;
    register n;

    outbuf_p = outbuf;

    for (; *s; s++) {
	if (mode == 'c'  &&  isspace(*s)) {
	    /* Eat whitespace in 'c' mode */
	    continue;
	}

	if (*s == '\\') {
	    switch (*++s) {
#ifdef __STDC__
	    case 'a':
		*outbuf_p++ = '\a';
		break;
#endif
	    case 'b':
		*outbuf_p++ = '\b';
		break;
	    case 'f':
		*outbuf_p++ = '\f';
		break;
	    case 'n':
		*outbuf_p++ = '\n';
		break;
	    case 'r':
		*outbuf_p++ = '\r';
		break;
	    case 't':
		*outbuf_p++ = '\t';
		break;
#ifdef __STDC__
	    case 'v':
		*outbuf_p++ = '\v';
		break;
#endif
	    case '\\':
		*outbuf_p++ = '\\';
		break;
	    case '^':
		*outbuf_p++ = '^';
		break;
	    case '\'':
		*outbuf_p++ = '\'';
		break;
	    case '"':
		*outbuf_p++ = '"';
		break;
	    case '?':
		*outbuf_p++ = '?';
		break;
	    case '0':
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
		translate_octal(c, s);
		s--;
		*outbuf_p++ = c;
		break;
	    case 'x':
		s++;
		translate_hex(c, s);
		s--;
		*outbuf_p++ = c;
		break;
	    default:
		*outbuf_p++ = *s;
		break;
	    }
#ifdef VIZ
	} else if (*s == '$' && *(s+1)) {
	    (void) sprintf(outbuf_p, "%d", count_reg[(int) *++s]);
	    outbuf_p += strlen(outbuf_p);
#endif
	} else if (*s == '^') {
	    n = (int) *++s + 1 - 'A';
	    *outbuf_p++ = n;
	} else if (*s == '\n') {
	    /* End of line */
	    *outbuf_p = '\0';
	    return;
	} else {
	    /* Print character literally. */
	    *outbuf_p++ = *s;
	}
    }
    *outbuf_p = '\0';
    return;
}
