#include <stdio.h>
#include <ctype.h>

/*
 * digit_a2d[c] maps ascii characters 0..9, a-f, A-F into the corresponding
 * integer digits.  It is NOT ok to give it anything but a digit character
 * as an argument.
 */
static int digit_a2d[104] = {
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*   0 -  7 */
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*   8 - 15 */
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*  16 - 23 */
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*  24 - 31 */
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*  32 - 39 */
		    0, 0, 0, 0, 0, 0, 0, 0,	/*  40 - 47 */
		    0, 1, 2, 3, 4, 5, 6, 7,	/*  48 - 55 */
		    8, 9, 0, 0, 0, 0, 0, 0,	/*  56 - 63 */
		    0,10,11,12,13,14,15, 0, 	/*  64 - 71 */
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*  72 - 79 */
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*  80 - 87 */
		    0, 0, 0, 0, 0, 0, 0, 0, 	/*  88 - 95 */
		    0,10,11,12,13,14,15, 0, };	/*  96 -103 */

unsigned long strtou(str, ptr, base)

/* Converts a string representation of a number to an unsigned long.  Leading
 * whitespace is ignored.  The string is scanned up to the first character
 * inconsistent with the base.  Valid numbers have one of the following
 * formats:
 *	0[xX]ddd -- hex number; ddd are 0-9, a-f, and A-F
 *	0[bB]ddd -- binary number; ddd are 0's and 1's
 *	0ddd     -- octal number; ddd are octal digits
 *	dddd     -- decimal number; ddd are decimal digits
 */

register char *str;  /* string to be converted */

char **ptr; /* if not (char **)NULL, ptr to char terminating scan is returned
             * in *ptr.
	     */

int base;   /* must be one of 0, 2, 8, 10, or 16, else function returns 0
             * If the base is zero, the correct base is determined according
             * as the string has one of the formats given above.
	     */

{
    unsigned long value=0;

    if (ptr)
	*ptr = str;

    /* Special case: null string */
    if (! *str)
	return 0;

    /* skip leading whitespace */
    while (isspace(*str))
        ++str;

	/* Check for end of string */
    if (*str == '\0')
        return 0;

    /* Determine base */
    if (base == 0) {
        if (*str != '0')
            base = 10;
        else if (*++str == 0) {
	    /* Special case: string is '0' */
	    if (ptr)
		*ptr = str;
	    return 0;
        } else if (*str == 'x' || *str == 'X') {
            base = 16;
            ++str;
        } else if (*str == 'b' || *str == 'B') {
            base = 2;
            ++str;
        } else {
            base = 8;
        }
    }

    /* Convert string */
    switch (base) {
    case 2:
        /* Skip 0[bB], if present */
        if (*str == '0')
            if (*++str == 'b' || *str == 'B')
                ++str;
more2:	while (*str == '0' || *str == '1') {
            value = value<<1 | digit_a2d[*str];
            ++str;
        }
	if (*str == ',') { /* allow for comma-separated numbers */
	    str++;
	    goto more2;
	}
        break;
    case 8:
        while (*str >= '0' && *str <= '7') {
            value  = value<<3 | digit_a2d[*str];
            ++str;
        }
        break;
    case 10:
        while (isdigit(*str)) {
            value  = value*10 + digit_a2d[*str];
            ++str;
        }
        break;
    case 16:
        /* Skip 0[xX], if present */
        if (*str == '0')
            if (*++str == 'x' || *str == 'X')
                ++str;
        while (isxdigit(*str)) {
	    value  = value<<4 | digit_a2d[*str];
            ++str;
        }
        break;
    default:
        return 0;
    }

    if (ptr)
	*ptr = str;

    return value;
}
