#ifdef __STDC__
#include <limits.h>
#endif
/* LONG_MAX is the largest allowed long.   Ideally, its value is larger
 * than the largest filesize that can be handled.
 */
#ifndef LONG_MAX
#define LONG_MAX (2147483647L)
#endif
/* -- Put the sizes of shorts, ints, and longs here.  (The sizeof operator
 * isn't sufficient because we need to use L_XXXX in the argument to a
 * #if expression.)
 */
#ifndef L_SHORT
#define L_SHORT	2
#endif
#ifndef L_INT
#define L_INT	4
#endif
#ifndef L_LONG
#define L_LONG	4
#endif
/* aligned(type) should evaluate to 1 if the pointer p is properly aligned
 * for data of type "type", where type is one of 'C' (char),
 * 'Z' (zero-terminated string), 'S' (short), 'I' (int), 'L' (long),
 * 'F' (float), or 'D' (double); it should evaluate to 0 otherwise.
 * It is used to decide if each datum in the input buffer is properly aligned --
 * if not, we have to copy it to an aligned boundary before interpreting it.
 * The default macro will work on most but not all machines.  It will work
 * properly if (a) all data sizes are powers of 2; (b) the architecture
 * uses byte address, not word address; and (c) after casting the
 * address to unsigned long, the alignment is indicated by the low-order bits.
 * This is not guaranteed to be true on all architectures, however, so you may
 * need to adjust the definition.
 * This default macro requires alignment of each datum on a boundary that's
 * a multiple of its own size.  It is unnecessarily restrictive for some
 * architectures (e.g. some architectures allow 4-byte quantities to start
 * on any 2-byte boundary).
 */
#ifndef aligned
#define aligned(type, p) ( \
 (type) == 'C' ? 1 :					\
   (type) == 'Z' ? 1 :					\
     (type) == 'S' ? !( (unsigned long) (p) & (sizeof(short)-1) ) :	\
       (type) == 'I' ? !( (unsigned long) (p) & (sizeof(int)-1) ) :	\
	 (type) == 'L' ? !( (unsigned long) (p) & (sizeof(long)-1) ) :	\
	   (type) == 'F' ? !( (unsigned long) (p) & (sizeof(float)-1) ) : \
	     /* assume 'D' */ !( (unsigned long) (p) & (sizeof(double)-1) ) )
#endif
