#include <stdio.h>
#include <stdlib.h>
#include "../config.h"
#ifdef WIN32
#include <winsock.h>
#else
# ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
# endif
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
#endif
#include "internal.h"
#include "sock.h"

extern struct sockaddr *sock_addr;

static struct in_addr *get_h_addr(const char *name)
{
	struct hostent *h = gethostbyname(name);
	if (!h) {
		printf("Unknown host \"%s\"\n", name);
		exit(1);
	}
	return (struct in_addr *) h->h_addr;
}

static void getaddr(const char *name, unsigned short port)
{
	struct sockaddr_in *addr;
	if (sock_addr)
		free(sock_addr);
	addr = malloc(sizeof(struct sockaddr_in));
	addr->sin_family = AF_INET;
	addr->sin_port = htons(port);
	if (name)
		addr->sin_addr = *get_h_addr(name);
	else
		addr->sin_addr.s_addr = htonl(INADDR_ANY);
	sock_addr = (struct sockaddr *) addr;
}

int mksocket_inet(const char *name, unsigned port)
{
	char *msg = mksocket(PF_INET);
	if (msg)
		goto err;
	getaddr(name, port);
	if (!name) {
		msg = bind_listen(sizeof(struct sockaddr_in));
		if (msg)
			goto err;
		printf("Listening for connections on port %d...\n", port);
		return 1;
	}
	printf("Connecting to %s on port %d...\n", name, port);
	if (connectsock(sizeof(struct sockaddr_in)))
		return 1;
	printf("FAILED! %s\n", sock_strerror());
	return 0;

err:	printf("%s\n", msg);
	free(msg);
	return 0;
}

int reconnect_inet()
{
	return sock_addr && connectsock(sizeof(struct sockaddr_in));
}
