#include "menu.h"
#include "menuext.h"
#include "../options.h"
#include "../game/tetris.h"	/* MODE_BTYPE */

static int gm_mode(int k, int *pos)
{
	const char *items[2] = {"A-type", "B-type"};
	union val v;
	int i;
	int ret;
	v.integ = getopt_int("", "mode");
	i = 1-!(v.integ & MODE_BTYPE);
	ret = selectitem(items, 2, &i, k);
	if (ret && k) {
		if (i)
			v.integ |= MODE_BTYPE;
		else
			v.integ &= ~MODE_BTYPE;
		setoption("", "mode", v, 0);
	}
	return ret;
}

int startup_menu(int i, int x, int y)
{
	union val v;
	const char *menu[6] = {
		"1-Player Game",
		"2-Player Game",
		"Mode",
		"-------------",
		"Options",
		"Highscores"
	};
	menuhandler handlers[6] = {0, 0, gm_mode};
	i = openmenu(menu, 6, i, x, y, handlers);
	if (i==1 || i==2) {
		v.integ = i | getopt_int("", "mode") & MODE_BTYPE;
		setoption("", "mode", v, 0);
	}
	return i;
}
