#include <string.h>
#include "menu.h"
#include "../input/input.h"
#include "../textgfx/textgfx.h"
#include "../draw/draw.h"
#include "../game/tetris.h"
#include "../game/game.h"
#include "../netw/sock.h"
#undef SOCKET
#define SOCKET 1
#include "internal.h"

int gamemenu_socket(const char **menu, int i, int x, int y, menuhandler *hs)
{
	int keypr;
	/* remove separator */
	memmove(menu+2, menu+3, 3*sizeof(*menu));
	memmove(hs+2, hs+3, 3*sizeof(*hs));
	if (i>2)
		i--;
	drawmenu(menu, 5, i, x, y, hs);
	while (1) {
		setcurs(x, y+5);
		newln(x);
		if (!(sock_flags & CONNECTED)) {
			printstr("Waiting for opponent...");
			if (sock_flags & CONN_PROXY) {
				clearbox(x, y+7, 0, 3);
				setcurs(x, y+6);
			}
		} else {
			sock_sendplayer();
			sock_sendbyte('h'); /* request height */
			sock_sendbyte('-');

			setattr_bold();
			printstr("PLAYER 2");
			cleartoeol();
			setattr_normal();
			newln(x+4);
			printstr("Level:  ");
			putch(player2.startlevel+'0');
			movefwd(4);
			printstr("Height:  ");
			putch(player2.height+'0');
		}
		newln(x);
		if (game->mode & MODE_BTYPE) {
			cleartoeol();
			newln(x);
			setattr_bold();
			printint("B-TYPE  LINES %d", player1.lineslimit);
			setattr_normal();
			newln(x);
			if (opponent_name[0])
				newln(x);
		} else {
			newln(x);
			cleartoeol();
		}
		if (opponent_name[0]) {
			if (my_name[0])
				printstr(my_name);
			else
				printstr("You");
			putch(' ');
			printstr(get_wonlost_stats(opponent_name));
			putch(' ');
			printstr(opponent_name);
			newln(x);
		}
		setcurs(x, y+i);
		refreshwin(-1);
		keypr = getkeypress(1000, 0);
		if (!keypr)
			continue;
		switch (handle_menuitem(menu, 5, &i, x, y+i, hs, keypr)) {
		case 0:
			clearbox(0, y+7, 0, 3);
			return 0;
		case 2:
			player2.height = 0;
			if (i>1)
				i++;
			return i+1;
		}
	}
}
