/* valaccodedelegatemodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
enum  {
	VALA_CCODE_DELEGATE_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeArrayModule* vala_ccode_array_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeArrayModule* vala_ccode_array_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_ccode_delegate_module_real_generate_delegate_declaration (ValaCCodeBaseModule* base, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_delegate_declaration (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d);
static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
char* vala_ccode_base_module_get_delegate_target_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
ValaDataType* vala_ccode_base_module_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr);
static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname);
static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d);
ValaCCodeExpression* vala_ccode_base_module_get_implicit_cast_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
gboolean vala_ccode_base_module_add_wrapper (ValaCCodeBaseModule* self, const char* wrapper_name);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
char* vala_ccode_base_module_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* self, const char* delegate_cname);
static void vala_ccode_delegate_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
static gpointer vala_ccode_delegate_module_parent_class = NULL;



ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeDelegateModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeDelegateModule*) vala_ccode_array_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_delegate_module_construct (VALA_TYPE_CCODE_DELEGATE_MODULE, codegen, next);
}


static void vala_ccode_delegate_module_real_generate_delegate_declaration (ValaCCodeBaseModule* base, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space) {
	ValaCCodeDelegateModule * self;
	char* _tmp0;
	gboolean _tmp1;
	char* _tmp2;
	ValaCCodeFunctionDeclarator* _tmp3;
	ValaCCodeFunctionDeclarator* cfundecl;
	gboolean _tmp12;
	GeeList* _tmp16;
	gboolean _tmp17;
	char* _tmp18;
	ValaCCodeTypeDefinition* _tmp19;
	ValaCCodeTypeDefinition* ctypedef;
	gboolean _tmp20;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (d != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0 = NULL;
	if ((_tmp1 = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) d, _tmp0 = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _tmp0 = (g_free (_tmp0), NULL), _tmp1)) {
		return;
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	cfundecl = (_tmp3 = vala_ccode_function_declarator_new (_tmp2 = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	{
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* _param_it;
		_tmp4 = NULL;
		_tmp5 = NULL;
		_param_it = (_tmp5 = gee_iterable_iterator ((GeeIterable*) (_tmp4 = vala_delegate_get_parameters (d))), (_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)), _tmp5);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			GeeHashMap* _tmp6;
			gboolean _tmp7;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp6 = NULL;
			vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, decl_space, (GeeMap*) (_tmp6 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal)), NULL);
			(_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL));
			vala_ccode_function_declarator_add_parameter (cfundecl, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
			_tmp7 = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp7 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp7 = FALSE;
			}
			/* handle array parameters*/
			if (_tmp7) {
				ValaArrayType* _tmp8;
				ValaArrayType* array_type;
				char* length_ctype;
				_tmp8 = NULL;
				array_type = (_tmp8 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8));
				length_ctype = g_strdup ("int");
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					char* _tmp9;
					_tmp9 = NULL;
					length_ctype = (_tmp9 = g_strdup ("int*"), length_ctype = (g_free (length_ctype), NULL), _tmp9);
				}
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						char* _tmp10;
						ValaCCodeFormalParameter* _tmp11;
						ValaCCodeFormalParameter* cparam;
						_tmp10 = NULL;
						_tmp11 = NULL;
						cparam = (_tmp11 = vala_ccode_formal_parameter_new (_tmp10 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) param), dim), length_ctype), _tmp10 = (g_free (_tmp10), NULL), _tmp11);
						vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
						(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
				length_ctype = (g_free (length_ctype), NULL);
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp12 = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp12 = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp12 = FALSE;
	}
	if (_tmp12) {
		ValaArrayType* _tmp13;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp13 = NULL;
		array_type = (_tmp13 = VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp14;
				ValaCCodeFormalParameter* _tmp15;
				ValaCCodeFormalParameter* cparam;
				_tmp14 = NULL;
				_tmp15 = NULL;
				cparam = (_tmp15 = vala_ccode_formal_parameter_new (_tmp14 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp14 = (g_free (_tmp14), NULL), _tmp15);
				vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("user_data", "void*");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	_tmp16 = NULL;
	if ((_tmp17 = gee_collection_get_size ((GeeCollection*) (_tmp16 = vala_code_node_get_error_types ((ValaCodeNode*) d))) > 0, (_tmp16 == NULL) ? NULL : (_tmp16 = (gee_collection_object_unref (_tmp16), NULL)), _tmp17)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		vala_ccode_function_declarator_add_parameter (cfundecl, cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	_tmp18 = NULL;
	_tmp19 = NULL;
	ctypedef = (_tmp19 = vala_ccode_type_definition_new (_tmp18 = vala_data_type_get_cname (vala_delegate_get_return_type (d)), (ValaCCodeDeclarator*) cfundecl), _tmp18 = (g_free (_tmp18), NULL), _tmp19);
	_tmp20 = FALSE;
	if (vala_code_node_get_source_reference ((ValaCodeNode*) d) != NULL) {
		_tmp20 = vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) d)) != NULL;
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		ValaCCodeComment* _tmp21;
		_tmp21 = NULL;
		vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) (_tmp21 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) d)))));
		(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	}
	vala_ccode_declaration_space_add_type_declaration (decl_space, (ValaCCodeNode*) ctypedef);
	(cfundecl == NULL) ? NULL : (cfundecl = (vala_ccode_node_unref (cfundecl), NULL));
	(ctypedef == NULL) ? NULL : (ctypedef = (vala_ccode_node_unref (ctypedef), NULL));
}


static void vala_ccode_delegate_module_real_visit_delegate (ValaCCodeModule* base, ValaDelegate* d) {
	ValaCCodeDelegateModule * self;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (d != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) d, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, ((ValaCCodeBaseModule*) self)->source_declarations);
}


static char* vala_ccode_delegate_module_real_get_delegate_target_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	return g_strdup_printf ("%s_target", delegate_cname);
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_delegate_target_cexpression (ValaCCodeBaseModule* base, ValaExpression* delegate_expr) {
	ValaCCodeDelegateModule * self;
	gboolean is_out;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_expr != NULL, NULL);
	is_out = FALSE;
	if (VALA_IS_UNARY_EXPRESSION (delegate_expr)) {
		ValaUnaryExpression* _tmp0;
		ValaUnaryExpression* unary_expr;
		gboolean _tmp1;
		_tmp0 = NULL;
		unary_expr = (_tmp0 = VALA_UNARY_EXPRESSION (delegate_expr), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		_tmp1 = FALSE;
		if (vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_OUT) {
			_tmp1 = TRUE;
		} else {
			_tmp1 = vala_unary_expression_get_operator (unary_expr) == VALA_UNARY_OPERATOR_REF;
		}
		if (_tmp1) {
			delegate_expr = vala_unary_expression_get_inner (unary_expr);
			is_out = TRUE;
		}
		(unary_expr == NULL) ? NULL : (unary_expr = (vala_code_node_unref (unary_expr), NULL));
	}
	if (VALA_IS_METHOD_CALL (delegate_expr)) {
		ValaMethodCall* _tmp2;
		ValaMethodCall* invocation_expr;
		ValaCCodeExpression* _tmp3;
		ValaCCodeExpression* _tmp4;
		_tmp2 = NULL;
		invocation_expr = (_tmp2 = VALA_METHOD_CALL (delegate_expr), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = NULL;
		_tmp4 = NULL;
		return (_tmp4 = (_tmp3 = vala_method_call_get_delegate_target (invocation_expr), (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3)), (invocation_expr == NULL) ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL)), _tmp4);
	} else {
		if (VALA_IS_LAMBDA_EXPRESSION (delegate_expr)) {
			gboolean _tmp5;
			gboolean _tmp6;
			_tmp5 = FALSE;
			_tmp6 = FALSE;
			if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
				_tmp6 = vala_method_get_binding (((ValaCCodeBaseModule*) self)->current_method) == MEMBER_BINDING_INSTANCE;
			} else {
				_tmp6 = FALSE;
			}
			if (_tmp6) {
				_tmp5 = TRUE;
			} else {
				_tmp5 = ((ValaCCodeBaseModule*) self)->in_constructor;
			}
			if (_tmp5) {
				return (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
			} else {
				return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
			}
		} else {
			if (vala_expression_get_symbol_reference (delegate_expr) != NULL) {
				if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr))) {
					ValaFormalParameter* _tmp9;
					ValaFormalParameter* param;
					char* _tmp10;
					ValaCCodeExpression* _tmp11;
					ValaCCodeExpression* target_expr;
					_tmp9 = NULL;
					param = (_tmp9 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (delegate_expr)), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
					_tmp10 = NULL;
					_tmp11 = NULL;
					target_expr = (_tmp11 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp10 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param))), _tmp10 = (g_free (_tmp10), NULL), _tmp11);
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeExpression* _tmp12;
						/* accessing argument of out/ref param*/
						_tmp12 = NULL;
						target_expr = (_tmp12 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, target_expr), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp12);
					}
					if (is_out) {
						ValaCCodeExpression* _tmp13;
						/* passing array as out/ref*/
						_tmp13 = NULL;
						return (_tmp13 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp13);
					} else {
						ValaCCodeExpression* _tmp14;
						_tmp14 = NULL;
						return (_tmp14 = target_expr, (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), _tmp14);
					}
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
				} else {
					if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr))) {
						ValaLocalVariable* _tmp15;
						ValaLocalVariable* local;
						char* _tmp16;
						ValaCCodeIdentifier* _tmp17;
						ValaCCodeIdentifier* target_expr;
						_tmp15 = NULL;
						local = (_tmp15 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (delegate_expr)), (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15));
						_tmp16 = NULL;
						_tmp17 = NULL;
						target_expr = (_tmp17 = vala_ccode_identifier_new (_tmp16 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) local))), _tmp16 = (g_free (_tmp16), NULL), _tmp17);
						if (is_out) {
							ValaCCodeExpression* _tmp18;
							_tmp18 = NULL;
							return (_tmp18 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) target_expr), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp18);
						} else {
							ValaCCodeExpression* _tmp19;
							_tmp19 = NULL;
							return (_tmp19 = (ValaCCodeExpression*) target_expr, (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp19);
						}
						(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
						(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
					} else {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (delegate_expr))) {
							ValaField* _tmp20;
							ValaField* field;
							char* _tmp21;
							char* _tmp22;
							char* target_cname;
							ValaMemberAccess* _tmp23;
							ValaMemberAccess* ma;
							ValaCCodeExpression* target_expr;
							_tmp20 = NULL;
							field = (_tmp20 = VALA_FIELD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp20 == NULL) ? NULL : vala_code_node_ref (_tmp20));
							_tmp21 = NULL;
							_tmp22 = NULL;
							target_cname = (_tmp22 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, _tmp21 = vala_field_get_cname (field)), _tmp21 = (g_free (_tmp21), NULL), _tmp22);
							_tmp23 = NULL;
							ma = (_tmp23 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp23 == NULL) ? NULL : vala_code_node_ref (_tmp23));
							target_expr = NULL;
							if (vala_field_get_binding (field) == MEMBER_BINDING_INSTANCE) {
								ValaDataType* _tmp24;
								ValaDataType* instance_expression_type;
								ValaDataType* instance_target_type;
								ValaCCodeExpression* pub_inst;
								ValaCCodeExpression* typed_inst;
								ValaCCodeExpression* inst;
								_tmp24 = NULL;
								instance_expression_type = (_tmp24 = vala_expression_get_value_type (vala_member_access_get_inner (ma)), (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24));
								instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)));
								pub_inst = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma)));
								typed_inst = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, pub_inst, instance_expression_type, instance_target_type, NULL);
								inst = NULL;
								if (vala_symbol_get_access ((ValaSymbol*) field) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
									ValaCCodeExpression* _tmp25;
									_tmp25 = NULL;
									inst = (_tmp25 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (typed_inst, "priv"), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp25);
								} else {
									ValaCCodeExpression* _tmp27;
									ValaCCodeExpression* _tmp26;
									_tmp27 = NULL;
									_tmp26 = NULL;
									inst = (_tmp27 = (_tmp26 = typed_inst, (_tmp26 == NULL) ? NULL : vala_ccode_node_ref (_tmp26)), (inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)), _tmp27);
								}
								if (vala_typesymbol_is_reference_type (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) field)))) {
									ValaCCodeExpression* _tmp28;
									_tmp28 = NULL;
									target_expr = (_tmp28 = (ValaCCodeExpression*) vala_ccode_member_access_new_pointer (inst, target_cname), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp28);
								} else {
									ValaCCodeExpression* _tmp29;
									_tmp29 = NULL;
									target_expr = (_tmp29 = (ValaCCodeExpression*) vala_ccode_member_access_new (inst, target_cname, FALSE), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp29);
								}
								(instance_expression_type == NULL) ? NULL : (instance_expression_type = (vala_code_node_unref (instance_expression_type), NULL));
								(instance_target_type == NULL) ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL));
								(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
								(typed_inst == NULL) ? NULL : (typed_inst = (vala_ccode_node_unref (typed_inst), NULL));
								(inst == NULL) ? NULL : (inst = (vala_ccode_node_unref (inst), NULL));
							} else {
								ValaCCodeExpression* _tmp30;
								_tmp30 = NULL;
								target_expr = (_tmp30 = (ValaCCodeExpression*) vala_ccode_identifier_new (target_cname), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp30);
							}
							if (is_out) {
								ValaCCodeExpression* _tmp31;
								_tmp31 = NULL;
								return (_tmp31 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, target_expr), (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), target_cname = (g_free (target_cname), NULL), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL)), _tmp31);
							} else {
								ValaCCodeExpression* _tmp32;
								_tmp32 = NULL;
								return (_tmp32 = target_expr, (field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL)), target_cname = (g_free (target_cname), NULL), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp32);
							}
							(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
							target_cname = (g_free (target_cname), NULL);
							(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							(target_expr == NULL) ? NULL : (target_expr = (vala_ccode_node_unref (target_expr), NULL));
						} else {
							if (VALA_IS_METHOD (vala_expression_get_symbol_reference (delegate_expr))) {
								ValaMethod* _tmp33;
								ValaMethod* m;
								ValaMemberAccess* _tmp34;
								ValaMemberAccess* ma;
								_tmp33 = NULL;
								m = (_tmp33 = VALA_METHOD (vala_expression_get_symbol_reference (delegate_expr)), (_tmp33 == NULL) ? NULL : vala_code_node_ref (_tmp33));
								_tmp34 = NULL;
								ma = (_tmp34 = VALA_MEMBER_ACCESS (delegate_expr), (_tmp34 == NULL) ? NULL : vala_code_node_ref (_tmp34));
								if (vala_method_get_binding (m) == MEMBER_BINDING_STATIC) {
									ValaCCodeExpression* _tmp35;
									_tmp35 = NULL;
									return (_tmp35 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp35);
								} else {
									ValaCCodeExpression* _tmp36;
									_tmp36 = NULL;
									return (_tmp36 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma))), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp36);
								}
								(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
								(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
							}
						}
					}
				}
			}
		}
	}
	return (ValaCCodeExpression*) vala_ccode_constant_new ("NULL");
}


static char* vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname (ValaCCodeBaseModule* base, const char* delegate_cname) {
	ValaCCodeDelegateModule * self;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (delegate_cname != NULL, NULL);
	return g_strdup_printf ("%s_target_destroy_notify", delegate_cname);
}


static ValaCCodeExpression* vala_ccode_delegate_module_real_get_implicit_cast_expression (ValaCCodeBaseModule* base, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr) {
	ValaCCodeDelegateModule * self;
	gboolean _tmp0;
	self = (ValaCCodeDelegateModule*) base;
	g_return_val_if_fail (source_cexpr != NULL, NULL);
	_tmp0 = FALSE;
	if (VALA_IS_DELEGATE_TYPE (target_type)) {
		_tmp0 = VALA_IS_METHOD_TYPE (expression_type);
	} else {
		_tmp0 = FALSE;
	}
	if (_tmp0) {
		ValaDelegateType* _tmp1;
		ValaDelegateType* dt;
		ValaMethodType* _tmp2;
		ValaMethodType* mt;
		ValaMethod* _tmp3;
		ValaMethod* method;
		char* _tmp8;
		ValaCCodeExpression* _tmp9;
		ValaCCodeExpression* _tmp10;
		_tmp1 = NULL;
		dt = (_tmp1 = VALA_DELEGATE_TYPE (target_type), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp2 = NULL;
		mt = (_tmp2 = VALA_METHOD_TYPE (expression_type), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = NULL;
		method = (_tmp3 = vala_method_type_get_method_symbol (mt), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
		if (vala_method_get_base_method (method) != NULL) {
			ValaMethod* _tmp5;
			ValaMethod* _tmp4;
			_tmp5 = NULL;
			_tmp4 = NULL;
			method = (_tmp5 = (_tmp4 = vala_method_get_base_method (method), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp5);
		} else {
			if (vala_method_get_base_interface_method (method) != NULL) {
				ValaMethod* _tmp7;
				ValaMethod* _tmp6;
				_tmp7 = NULL;
				_tmp6 = NULL;
				method = (_tmp7 = (_tmp6 = vala_method_get_base_interface_method (method), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp7);
			}
		}
		_tmp8 = NULL;
		_tmp9 = NULL;
		_tmp10 = NULL;
		return (_tmp10 = (_tmp9 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp8 = vala_ccode_delegate_module_generate_delegate_wrapper (self, method, vala_delegate_type_get_delegate_symbol (dt))), _tmp8 = (g_free (_tmp8), NULL), _tmp9), (dt == NULL) ? NULL : (dt = (vala_code_node_unref (dt), NULL)), (mt == NULL) ? NULL : (mt = (vala_code_node_unref (mt), NULL)), (method == NULL) ? NULL : (method = (vala_code_node_unref (method), NULL)), _tmp10);
	} else {
		return VALA_CCODE_BASE_MODULE_CLASS (vala_ccode_delegate_module_parent_class)->get_implicit_cast_expression ((ValaCCodeBaseModule*) VALA_CCODE_ARRAY_MODULE (self), source_cexpr, expression_type, target_type, expr);
	}
}


static char* vala_ccode_delegate_module_generate_delegate_wrapper (ValaCCodeDelegateModule* self, ValaMethod* m, ValaDelegate* d) {
	char* delegate_name;
	ValaSignal* _tmp1;
	ValaSymbol* _tmp0;
	ValaSignal* sig;
	ValaDynamicSignal* _tmp3;
	ValaSignal* _tmp2;
	ValaDynamicSignal* dynamic_sig;
	char* _tmp10;
	char* _tmp11;
	char* wrapper_name;
	char* _tmp13;
	ValaCCodeFunction* _tmp14;
	ValaCCodeFunction* function;
	GeeHashMap* cparam_map;
	GeeList* d_params;
	gboolean _tmp15;
	GeeList* _tmp19;
	gboolean _tmp20;
	gint last_pos;
	gint min_pos;
	GeeHashMap* carg_map;
	gint i;
	gboolean first;
	gboolean _tmp56;
	GeeList* _tmp61;
	gboolean _tmp62;
	ValaCCodeIdentifier* _tmp65;
	char* _tmp64;
	ValaCCodeFunctionCall* _tmp66;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp74;
	char* _tmp75;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);
	delegate_name = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	sig = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol ((ValaSymbol*) d), VALA_IS_SIGNAL (_tmp0) ? ((ValaSignal*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp3 = NULL;
	_tmp2 = NULL;
	dynamic_sig = (_tmp3 = (_tmp2 = sig, VALA_IS_DYNAMIC_SIGNAL (_tmp2) ? ((ValaDynamicSignal*) _tmp2) : NULL), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	if (dynamic_sig != NULL) {
		char* _tmp4;
		_tmp4 = NULL;
		delegate_name = (_tmp4 = vala_ccode_module_get_dynamic_signal_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), dynamic_sig), delegate_name = (g_free (delegate_name), NULL), _tmp4);
	} else {
		if (sig != NULL) {
			char* _tmp7;
			char* _tmp6;
			char* _tmp5;
			_tmp7 = NULL;
			_tmp6 = NULL;
			_tmp5 = NULL;
			delegate_name = (_tmp7 = g_strconcat (_tmp5 = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), _tmp6 = vala_signal_get_cname (sig), NULL), delegate_name = (g_free (delegate_name), NULL), _tmp7);
			_tmp6 = (g_free (_tmp6), NULL);
			_tmp5 = (g_free (_tmp5), NULL);
		} else {
			char* _tmp9;
			char* _tmp8;
			_tmp9 = NULL;
			_tmp8 = NULL;
			delegate_name = (_tmp9 = vala_symbol_camel_case_to_lower_case (_tmp8 = vala_typesymbol_get_cname ((ValaTypeSymbol*) d, FALSE)), delegate_name = (g_free (delegate_name), NULL), _tmp9);
			_tmp8 = (g_free (_tmp8), NULL);
		}
	}
	_tmp10 = NULL;
	_tmp11 = NULL;
	wrapper_name = (_tmp11 = g_strdup_printf ("_%s_%s", _tmp10 = vala_method_get_cname (m), delegate_name), _tmp10 = (g_free (_tmp10), NULL), _tmp11);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, wrapper_name)) {
		char* _tmp12;
		/* wrapper already defined*/
		_tmp12 = NULL;
		return (_tmp12 = wrapper_name, delegate_name = (g_free (delegate_name), NULL), (sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL)), (dynamic_sig == NULL) ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL)), _tmp12);
	}
	/* declaration*/
	_tmp13 = NULL;
	_tmp14 = NULL;
	function = (_tmp14 = vala_ccode_function_new (wrapper_name, _tmp13 = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp13 = (g_free (_tmp13), NULL), _tmp14);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode ((ValaCodeNode*) m, (ValaCCodeNode*) function);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	if (vala_delegate_get_has_target (d)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("self", "gpointer");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	if (vala_delegate_get_sender_type (d) != NULL) {
		ValaFormalParameter* param;
		param = vala_formal_parameter_new ("_sender", vala_delegate_get_sender_type (d), NULL);
		vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, NULL);
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	d_params = vala_delegate_get_parameters (d);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) d_params);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, param, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, NULL);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp15 = FALSE;
	if (!vala_delegate_get_no_array_length (d)) {
		_tmp15 = VALA_IS_ARRAY_TYPE (vala_delegate_get_return_type (d));
	} else {
		_tmp15 = FALSE;
	}
	if (_tmp15) {
		ValaArrayType* _tmp16;
		ValaArrayType* array_type;
		/* return array length if appropriate*/
		_tmp16 = NULL;
		array_type = (_tmp16 = VALA_ARRAY_TYPE (vala_delegate_get_return_type (d)), (_tmp16 == NULL) ? NULL : vala_code_node_ref (_tmp16));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				char* _tmp17;
				ValaCCodeFormalParameter* _tmp18;
				ValaCCodeFormalParameter* cparam;
				_tmp17 = NULL;
				_tmp18 = NULL;
				cparam = (_tmp18 = vala_ccode_formal_parameter_new (_tmp17 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim), "int*"), _tmp17 = (g_free (_tmp17), NULL), _tmp18);
				gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_carray_length_parameter_position (d) + (0.01 * dim), FALSE)), cparam);
				(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp19 = NULL;
	if ((_tmp20 = gee_collection_get_size ((GeeCollection*) (_tmp19 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp19 == NULL) ? NULL : (_tmp19 = (gee_collection_object_unref (_tmp19), NULL)), _tmp20)) {
		ValaCCodeFormalParameter* cparam;
		cparam = vala_ccode_formal_parameter_new ("error", "GError**");
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), cparam);
		(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
	}
	/* append C parameters in the right order*/
	last_pos = -1;
	min_pos = 0;
	while (TRUE) {
		ValaCCodeFormalParameter* _tmp25;
		min_pos = -1;
		{
			GeeSet* _tmp21;
			GeeIterator* _tmp22;
			GeeIterator* _pos_it;
			_tmp21 = NULL;
			_tmp22 = NULL;
			_pos_it = (_tmp22 = gee_iterable_iterator ((GeeIterable*) (_tmp21 = gee_map_get_keys ((GeeMap*) cparam_map))), (_tmp21 == NULL) ? NULL : (_tmp21 = (gee_collection_object_unref (_tmp21), NULL)), _tmp22);
			while (gee_iterator_next (_pos_it)) {
				gint pos;
				gboolean _tmp23;
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp23 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp24;
					_tmp24 = FALSE;
					if (min_pos == (-1)) {
						_tmp24 = TRUE;
					} else {
						_tmp24 = pos < min_pos;
					}
					_tmp23 = _tmp24;
				} else {
					_tmp23 = FALSE;
				}
				if (_tmp23) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp25 = NULL;
		vala_ccode_function_add_parameter (function, _tmp25 = (ValaCCodeFormalParameter*) gee_map_get ((GeeMap*) cparam_map, GINT_TO_POINTER (min_pos)));
		(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
		last_pos = min_pos;
	}
	/* definition*/
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	i = 0;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpression* arg;
		arg = NULL;
		if (vala_delegate_get_has_target (d)) {
			ValaCCodeExpression* _tmp26;
			_tmp26 = NULL;
			arg = (_tmp26 = (ValaCCodeExpression*) vala_ccode_identifier_new ("self"), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp26);
		} else {
			ValaCCodeExpression* _tmp29;
			ValaFormalParameter* _tmp27;
			ValaCCodeNode* _tmp28;
			/* use first delegate parameter as instance*/
			_tmp29 = NULL;
			_tmp27 = NULL;
			_tmp28 = NULL;
			arg = (_tmp29 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name ((_tmp28 = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp27 = (ValaFormalParameter*) gee_list_get (d_params, 0))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp28) ? ((ValaCCodeFormalParameter*) _tmp28) : NULL))), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp29);
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_code_node_unref (_tmp27), NULL));
			i = 1;
		}
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), arg);
		(arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL));
	}
	first = TRUE;
	{
		GeeList* _tmp30;
		GeeIterator* _tmp31;
		GeeIterator* _param_it;
		_tmp30 = NULL;
		_tmp31 = NULL;
		_param_it = (_tmp31 = gee_iterable_iterator ((GeeIterable*) (_tmp30 = vala_method_get_parameters (m))), (_tmp30 == NULL) ? NULL : (_tmp30 = (gee_collection_object_unref (_tmp30), NULL)), _tmp31);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp32;
			gboolean _tmp33;
			ValaCCodeExpression* arg;
			ValaCCodeExpression* _tmp39;
			ValaFormalParameter* _tmp37;
			ValaCCodeNode* _tmp38;
			gboolean _tmp40;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp32 = FALSE;
			_tmp33 = FALSE;
			if (first) {
				_tmp33 = vala_delegate_get_sender_type (d) != NULL;
			} else {
				_tmp33 = FALSE;
			}
			if (_tmp33) {
				GeeList* _tmp35;
				GeeList* _tmp34;
				_tmp35 = NULL;
				_tmp34 = NULL;
				_tmp32 = gee_collection_get_size ((GeeCollection*) (_tmp34 = vala_method_get_parameters (m))) == (gee_collection_get_size ((GeeCollection*) (_tmp35 = vala_delegate_get_parameters (d))) + 1);
				(_tmp35 == NULL) ? NULL : (_tmp35 = (gee_collection_object_unref (_tmp35), NULL));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (gee_collection_object_unref (_tmp34), NULL));
			} else {
				_tmp32 = FALSE;
			}
			if (_tmp32) {
				ValaCCodeIdentifier* _tmp36;
				/* sender parameter*/
				_tmp36 = NULL;
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("_sender")));
				(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
				first = FALSE;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				continue;
			}
			arg = NULL;
			_tmp39 = NULL;
			_tmp37 = NULL;
			_tmp38 = NULL;
			arg = (_tmp39 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name ((_tmp38 = vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp37 = (ValaFormalParameter*) gee_list_get (d_params, i))), VALA_IS_CCODE_FORMAL_PARAMETER (_tmp38) ? ((ValaCCodeFormalParameter*) _tmp38) : NULL))), (arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL)), _tmp39);
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_code_node_unref (_tmp37), NULL));
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), arg);
			_tmp40 = FALSE;
			if (!vala_formal_parameter_get_no_array_length (param)) {
				_tmp40 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
			} else {
				_tmp40 = FALSE;
			}
			/* handle array arguments*/
			if (_tmp40) {
				ValaArrayType* _tmp41;
				ValaArrayType* array_type;
				_tmp41 = NULL;
				array_type = (_tmp41 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp41 == NULL) ? NULL : vala_code_node_ref (_tmp41));
				{
					gint dim;
					dim = 1;
					for (; dim <= vala_array_type_get_rank (array_type); dim++) {
						ValaCCodeExpression* clength;
						ValaFormalParameter* _tmp42;
						gboolean _tmp43;
						clength = NULL;
						_tmp42 = NULL;
						if ((_tmp43 = vala_formal_parameter_get_array_null_terminated (_tmp42 = (ValaFormalParameter*) gee_list_get (d_params, i)), (_tmp42 == NULL) ? NULL : (_tmp42 = (vala_code_node_unref (_tmp42), NULL)), _tmp43)) {
							ValaCCodeIdentifier* _tmp44;
							ValaCCodeFunctionCall* _tmp45;
							ValaCCodeFunctionCall* len_call;
							ValaCCodeIdentifier* _tmp47;
							ValaFormalParameter* _tmp46;
							ValaCCodeExpression* _tmp49;
							ValaCCodeExpression* _tmp48;
							((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
							_tmp44 = NULL;
							_tmp45 = NULL;
							len_call = (_tmp45 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)), _tmp45);
							_tmp47 = NULL;
							_tmp46 = NULL;
							vala_ccode_function_call_add_argument (len_call, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) (_tmp46 = (ValaFormalParameter*) gee_list_get (d_params, i))))));
							(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
							(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_code_node_unref (_tmp46), NULL));
							_tmp49 = NULL;
							_tmp48 = NULL;
							clength = (_tmp49 = (_tmp48 = (ValaCCodeExpression*) len_call, (_tmp48 == NULL) ? NULL : vala_ccode_node_ref (_tmp48)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp49);
							(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
						} else {
							ValaFormalParameter* _tmp50;
							gboolean _tmp51;
							_tmp50 = NULL;
							if ((_tmp51 = vala_formal_parameter_get_no_array_length (_tmp50 = (ValaFormalParameter*) gee_list_get (d_params, i)), (_tmp50 == NULL) ? NULL : (_tmp50 = (vala_code_node_unref (_tmp50), NULL)), _tmp51)) {
								ValaCCodeExpression* _tmp52;
								_tmp52 = NULL;
								clength = (_tmp52 = (ValaCCodeExpression*) vala_ccode_constant_new ("-1"), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp52);
							} else {
								ValaCCodeExpression* _tmp55;
								char* _tmp54;
								ValaFormalParameter* _tmp53;
								_tmp55 = NULL;
								_tmp54 = NULL;
								_tmp53 = NULL;
								clength = (_tmp55 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp54 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_symbol_get_name ((ValaSymbol*) (_tmp53 = (ValaFormalParameter*) gee_list_get (d_params, i))), dim)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp55);
								_tmp54 = (g_free (_tmp54), NULL);
								(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_code_node_unref (_tmp53), NULL));
							}
						}
						gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), clength);
						(clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL));
					}
				}
				(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
			}
			i++;
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			(arg == NULL) ? NULL : (arg = (vala_ccode_node_unref (arg), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp56 = FALSE;
	if (!vala_method_get_no_array_length (m)) {
		_tmp56 = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp56 = FALSE;
	}
	if (_tmp56) {
		ValaArrayType* _tmp57;
		ValaArrayType* array_type;
		_tmp57 = NULL;
		array_type = (_tmp57 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp57 == NULL) ? NULL : vala_code_node_ref (_tmp57));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				ValaCCodeExpression* clength;
				clength = NULL;
				if (vala_delegate_get_no_array_length (d)) {
					ValaCCodeExpression* _tmp58;
					_tmp58 = NULL;
					clength = (_tmp58 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp58);
				} else {
					ValaCCodeExpression* _tmp60;
					char* _tmp59;
					_tmp60 = NULL;
					_tmp59 = NULL;
					clength = (_tmp60 = (ValaCCodeExpression*) vala_ccode_identifier_new (_tmp59 = vala_ccode_module_get_array_length_cname (vala_ccode_module_get_head ((ValaCCodeModule*) self), "result", dim)), (clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL)), _tmp60);
					_tmp59 = (g_free (_tmp59), NULL);
				}
				gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), clength);
				(clength == NULL) ? NULL : (clength = (vala_ccode_node_unref (clength), NULL));
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	}
	_tmp61 = NULL;
	if ((_tmp62 = gee_collection_get_size ((GeeCollection*) (_tmp61 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0, (_tmp61 == NULL) ? NULL : (_tmp61 = (gee_collection_object_unref (_tmp61), NULL)), _tmp62)) {
		ValaCCodeIdentifier* _tmp63;
		_tmp63 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new ("error")));
		(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
	}
	_tmp65 = NULL;
	_tmp64 = NULL;
	_tmp66 = NULL;
	ccall = (_tmp66 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new (_tmp64 = vala_method_get_cname (m)))), (_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)), _tmp64 = (g_free (_tmp64), NULL), _tmp66);
	/* append C arguments in the right order*/
	last_pos = -1;
	while (TRUE) {
		ValaCCodeExpression* _tmp71;
		min_pos = -1;
		{
			GeeSet* _tmp67;
			GeeIterator* _tmp68;
			GeeIterator* _pos_it;
			_tmp67 = NULL;
			_tmp68 = NULL;
			_pos_it = (_tmp68 = gee_iterable_iterator ((GeeIterable*) (_tmp67 = gee_map_get_keys ((GeeMap*) carg_map))), (_tmp67 == NULL) ? NULL : (_tmp67 = (gee_collection_object_unref (_tmp67), NULL)), _tmp68);
			while (gee_iterator_next (_pos_it)) {
				gint pos;
				gboolean _tmp69;
				pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
				_tmp69 = FALSE;
				if (pos > last_pos) {
					gboolean _tmp70;
					_tmp70 = FALSE;
					if (min_pos == (-1)) {
						_tmp70 = TRUE;
					} else {
						_tmp70 = pos < min_pos;
					}
					_tmp69 = _tmp70;
				} else {
					_tmp69 = FALSE;
				}
				if (_tmp69) {
					min_pos = pos;
				}
			}
			(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
		}
		if (min_pos == (-1)) {
			break;
		}
		_tmp71 = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp71 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) carg_map, GINT_TO_POINTER (min_pos)));
		(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
		last_pos = min_pos;
	}
	block = vala_ccode_block_new ();
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpressionStatement* _tmp72;
		_tmp72 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp72 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
	} else {
		ValaCCodeReturnStatement* _tmp73;
		_tmp73 = NULL;
		vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp73 = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
	}
	/* append to file*/
	_tmp74 = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp74 = vala_ccode_function_copy (function)));
	(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	_tmp75 = NULL;
	return (_tmp75 = wrapper_name, delegate_name = (g_free (delegate_name), NULL), (sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL)), (dynamic_sig == NULL) ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL)), (function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL)), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), (d_params == NULL) ? NULL : (d_params = (gee_collection_object_unref (d_params), NULL)), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp75);
}


static void vala_ccode_delegate_module_real_generate_parameter (ValaCCodeMethodModule* base, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map) {
	ValaCCodeDelegateModule * self;
	gboolean _tmp0;
	char* ctypename;
	ValaCCodeFormalParameter* _tmp2;
	self = (ValaCCodeDelegateModule*) base;
	g_return_if_fail (param != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (cparam_map != NULL);
	_tmp0 = FALSE;
	if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param));
	}
	if (!_tmp0) {
		VALA_CCODE_METHOD_MODULE_CLASS (vala_ccode_delegate_module_parent_class)->generate_parameter ((ValaCCodeMethodModule*) VALA_CCODE_ARRAY_MODULE (self), param, decl_space, cparam_map, carg_map);
		return;
	}
	ctypename = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param));
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		char* _tmp1;
		_tmp1 = NULL;
		ctypename = (_tmp1 = g_strconcat (ctypename, "*", NULL), ctypename = (g_free (ctypename), NULL), _tmp1);
	}
	_tmp2 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) param, (ValaCCodeNode*) (_tmp2 = vala_ccode_formal_parameter_new (vala_symbol_get_name ((ValaSymbol*) param), ctypename)));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode ((ValaCodeNode*) param)));
	if (carg_map != NULL) {
		ValaCCodeIdentifier* _tmp3;
		_tmp3 = NULL;
		gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	}
	if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		ValaDelegateType* _tmp4;
		ValaDelegateType* deleg_type;
		ValaDelegate* _tmp5;
		ValaDelegate* d;
		_tmp4 = NULL;
		deleg_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
		_tmp5 = NULL;
		d = (_tmp5 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
		vala_ccode_base_module_generate_delegate_declaration ((ValaCCodeBaseModule*) self, d, decl_space);
		if (vala_delegate_get_has_target (d)) {
			char* _tmp6;
			ValaCCodeFormalParameter* _tmp7;
			ValaCCodeFormalParameter* cparam;
			_tmp6 = NULL;
			_tmp7 = NULL;
			cparam = (_tmp7 = vala_ccode_formal_parameter_new (_tmp6 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "void*"), _tmp6 = (g_free (_tmp6), NULL), _tmp7);
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeIdentifier* _tmp8;
				_tmp8 = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
				(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
			}
			if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
				ValaCCodeFormalParameter* _tmp10;
				char* _tmp9;
				_tmp10 = NULL;
				_tmp9 = NULL;
				cparam = (_tmp10 = vala_ccode_formal_parameter_new (_tmp9 = vala_ccode_base_module_get_delegate_target_destroy_notify_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "GDestroyNotify"), (cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL)), _tmp10);
				_tmp9 = (g_free (_tmp9), NULL);
				gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), cparam);
				if (carg_map != NULL) {
					ValaCCodeIdentifier* _tmp11;
					_tmp11 = NULL;
					gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
					(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
				}
			}
			(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
		}
		(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
		(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
	} else {
		if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
			char* _tmp12;
			ValaCCodeFormalParameter* _tmp13;
			ValaCCodeFormalParameter* cparam;
			_tmp12 = NULL;
			_tmp13 = NULL;
			cparam = (_tmp13 = vala_ccode_formal_parameter_new (_tmp12 = vala_ccode_base_module_get_delegate_target_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)), "void*"), _tmp12 = (g_free (_tmp12), NULL), _tmp13);
			gee_map_set (cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), cparam);
			if (carg_map != NULL) {
				ValaCCodeIdentifier* _tmp14;
				_tmp14 = NULL;
				gee_map_set (carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new (vala_ccode_formal_parameter_get_name (cparam))));
				(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			}
			(cparam == NULL) ? NULL : (cparam = (vala_ccode_node_unref (cparam), NULL));
		}
	}
	ctypename = (g_free (ctypename), NULL);
}


static void vala_ccode_delegate_module_class_init (ValaCCodeDelegateModuleClass * klass) {
	vala_ccode_delegate_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_delegate_declaration = vala_ccode_delegate_module_real_generate_delegate_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_delegate = vala_ccode_delegate_module_real_visit_delegate;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cname = vala_ccode_delegate_module_real_get_delegate_target_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_cexpression = vala_ccode_delegate_module_real_get_delegate_target_cexpression;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_delegate_target_destroy_notify_cname = vala_ccode_delegate_module_real_get_delegate_target_destroy_notify_cname;
	VALA_CCODE_BASE_MODULE_CLASS (klass)->get_implicit_cast_expression = vala_ccode_delegate_module_real_get_implicit_cast_expression;
	VALA_CCODE_METHOD_MODULE_CLASS (klass)->generate_parameter = vala_ccode_delegate_module_real_generate_parameter;
}


static void vala_ccode_delegate_module_instance_init (ValaCCodeDelegateModule * self) {
}


GType vala_ccode_delegate_module_get_type (void) {
	static GType vala_ccode_delegate_module_type_id = 0;
	if (vala_ccode_delegate_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeDelegateModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_delegate_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeDelegateModule), 0, (GInstanceInitFunc) vala_ccode_delegate_module_instance_init, NULL };
		vala_ccode_delegate_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ARRAY_MODULE, "ValaCCodeDelegateModule", &g_define_type_info, 0);
	}
	return vala_ccode_delegate_module_type_id;
}




